package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class Attribution {
  private String clientId;

  private AttributionSource source;

  private Reference userRef;

  public Attribution() {
  }

  public Attribution(String clientId, AttributionSource source, Reference userRef) {
    this.clientId = clientId;
    this.source = source;
    this.userRef = userRef;
  }

  public String getClientId() {
    return clientId;
  }

  public void setClientId(String clientId) {
    this.clientId = clientId;
  }

  public AttributionSource getSource() {
    return source;
  }

  public void setSource(AttributionSource source) {
    this.source = source;
  }

  public Reference getUserRef() {
    return userRef;
  }

  public void setUserRef(Reference userRef) {
    this.userRef = userRef;
  }

  @Override
  public String toString() {
    return "Attribution{clientId='" + clientId + "', source='" + source + "', userRef='" + userRef + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Attribution that = (Attribution) o;
    return Objects.equals(clientId, that.clientId) &&
        Objects.equals(source, that.source) &&
        Objects.equals(userRef, that.userRef);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clientId, source, userRef);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String clientId;

    private AttributionSource source;

    private Reference userRef;

    public Attribution build() {
      Attribution result = new Attribution();
      result.clientId = this.clientId;
      result.source = this.source;
      result.userRef = this.userRef;
      return result;
    }

    public Builder clientId(String clientId) {
      this.clientId = clientId;
      return this;
    }

    public Builder source(AttributionSource source) {
      this.source = source;
      return this;
    }

    public Builder userRef(Reference userRef) {
      this.userRef = userRef;
      return this;
    }
  }
}
