package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AuthorizationHeader implements com.commercetools.graphql.api.types.HttpDestinationAuthentication {
  private String headerValue;

  private String type;

  public AuthorizationHeader() {
  }

  public AuthorizationHeader(String headerValue, String type) {
    this.headerValue = headerValue;
    this.type = type;
  }

  public String getHeaderValue() {
    return headerValue;
  }

  public void setHeaderValue(String headerValue) {
    this.headerValue = headerValue;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "AuthorizationHeader{headerValue='" + headerValue + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuthorizationHeader that = (AuthorizationHeader) o;
    return Objects.equals(headerValue, that.headerValue) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(headerValue, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String headerValue;

    private String type;

    public AuthorizationHeader build() {
      AuthorizationHeader result = new AuthorizationHeader();
      result.headerValue = this.headerValue;
      result.type = this.type;
      return result;
    }

    public Builder headerValue(String headerValue) {
      this.headerValue = headerValue;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
