package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AzureServiceBusDestination implements com.commercetools.graphql.api.types.Destination {
  private String connectionString;

  private String type;

  public AzureServiceBusDestination() {
  }

  public AzureServiceBusDestination(String connectionString, String type) {
    this.connectionString = connectionString;
    this.type = type;
  }

  public String getConnectionString() {
    return connectionString;
  }

  public void setConnectionString(String connectionString) {
    this.connectionString = connectionString;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "AzureServiceBusDestination{connectionString='" + connectionString + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AzureServiceBusDestination that = (AzureServiceBusDestination) o;
    return Objects.equals(connectionString, that.connectionString) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(connectionString, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String connectionString;

    private String type;

    public AzureServiceBusDestination build() {
      AzureServiceBusDestination result = new AzureServiceBusDestination();
      result.connectionString = this.connectionString;
      result.type = this.type;
      return result;
    }

    public Builder connectionString(String connectionString) {
      this.connectionString = connectionString;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
