package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Long;
import java.lang.String;
import java.util.Currency;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = HighPrecisionMoney.class, name = "HighPrecisionMoney"),
    @JsonSubTypes.Type(value = Money.class, name = "Money")
})
public interface BaseMoney {
  String getType();

  void setType(String type);

  Currency getCurrencyCode();

  void setCurrencyCode(Currency currencyCode);

  Long getCentAmount();

  void setCentAmount(Long centAmount);

  Integer getFractionDigits();

  void setFractionDigits(Integer fractionDigits);
}
