package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class BaseMoneyInput {
  private MoneyInput centPrecision;

  private HighPrecisionMoneyInput highPrecision;

  public BaseMoneyInput() {
  }

  public BaseMoneyInput(MoneyInput centPrecision, HighPrecisionMoneyInput highPrecision) {
    this.centPrecision = centPrecision;
    this.highPrecision = highPrecision;
  }

  public MoneyInput getCentPrecision() {
    return centPrecision;
  }

  public void setCentPrecision(MoneyInput centPrecision) {
    this.centPrecision = centPrecision;
  }

  public HighPrecisionMoneyInput getHighPrecision() {
    return highPrecision;
  }

  public void setHighPrecision(HighPrecisionMoneyInput highPrecision) {
    this.highPrecision = highPrecision;
  }

  @Override
  public String toString() {
    return "BaseMoneyInput{centPrecision='" + centPrecision + "', highPrecision='" + highPrecision + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BaseMoneyInput that = (BaseMoneyInput) o;
    return Objects.equals(centPrecision, that.centPrecision) &&
        Objects.equals(highPrecision, that.highPrecision);
  }

  @Override
  public int hashCode() {
    return Objects.hash(centPrecision, highPrecision);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MoneyInput centPrecision;

    private HighPrecisionMoneyInput highPrecision;

    public BaseMoneyInput build() {
      BaseMoneyInput result = new BaseMoneyInput();
      result.centPrecision = this.centPrecision;
      result.highPrecision = this.highPrecision;
      return result;
    }

    public Builder centPrecision(MoneyInput centPrecision) {
      this.centPrecision = centPrecision;
      return this;
    }

    public Builder highPrecision(HighPrecisionMoneyInput highPrecision) {
      this.highPrecision = highPrecision;
      return this;
    }
  }
}
