package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class BaseSearchKeywordInput {
  private WhitespaceSuggestTokenizerInput whitespace;

  private CustomSuggestTokenizerInput custom;

  public BaseSearchKeywordInput() {
  }

  public BaseSearchKeywordInput(WhitespaceSuggestTokenizerInput whitespace,
      CustomSuggestTokenizerInput custom) {
    this.whitespace = whitespace;
    this.custom = custom;
  }

  public WhitespaceSuggestTokenizerInput getWhitespace() {
    return whitespace;
  }

  public void setWhitespace(WhitespaceSuggestTokenizerInput whitespace) {
    this.whitespace = whitespace;
  }

  public CustomSuggestTokenizerInput getCustom() {
    return custom;
  }

  public void setCustom(CustomSuggestTokenizerInput custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "BaseSearchKeywordInput{whitespace='" + whitespace + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BaseSearchKeywordInput that = (BaseSearchKeywordInput) o;
    return Objects.equals(whitespace, that.whitespace) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(whitespace, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private WhitespaceSuggestTokenizerInput whitespace;

    private CustomSuggestTokenizerInput custom;

    public BaseSearchKeywordInput build() {
      BaseSearchKeywordInput result = new BaseSearchKeywordInput();
      result.whitespace = this.whitespace;
      result.custom = this.custom;
      return result;
    }

    public Builder whitespace(WhitespaceSuggestTokenizerInput whitespace) {
      this.whitespace = whitespace;
      return this;
    }

    public Builder custom(CustomSuggestTokenizerInput custom) {
      this.custom = custom;
      return this;
    }
  }
}
