package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitApprovalRuleModeChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private BusinessUnitApprovalRuleMode approvalRuleMode;

  private BusinessUnitApprovalRuleMode oldApprovalRuleMode;

  private String type;

  public BusinessUnitApprovalRuleModeChanged() {
  }

  public BusinessUnitApprovalRuleModeChanged(BusinessUnitApprovalRuleMode approvalRuleMode,
      BusinessUnitApprovalRuleMode oldApprovalRuleMode, String type) {
    this.approvalRuleMode = approvalRuleMode;
    this.oldApprovalRuleMode = oldApprovalRuleMode;
    this.type = type;
  }

  public BusinessUnitApprovalRuleMode getApprovalRuleMode() {
    return approvalRuleMode;
  }

  public void setApprovalRuleMode(BusinessUnitApprovalRuleMode approvalRuleMode) {
    this.approvalRuleMode = approvalRuleMode;
  }

  public BusinessUnitApprovalRuleMode getOldApprovalRuleMode() {
    return oldApprovalRuleMode;
  }

  public void setOldApprovalRuleMode(BusinessUnitApprovalRuleMode oldApprovalRuleMode) {
    this.oldApprovalRuleMode = oldApprovalRuleMode;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitApprovalRuleModeChanged{approvalRuleMode='" + approvalRuleMode + "', oldApprovalRuleMode='" + oldApprovalRuleMode + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitApprovalRuleModeChanged that = (BusinessUnitApprovalRuleModeChanged) o;
    return Objects.equals(approvalRuleMode, that.approvalRuleMode) &&
        Objects.equals(oldApprovalRuleMode, that.oldApprovalRuleMode) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(approvalRuleMode, oldApprovalRuleMode, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BusinessUnitApprovalRuleMode approvalRuleMode;

    private BusinessUnitApprovalRuleMode oldApprovalRuleMode;

    private String type;

    public BusinessUnitApprovalRuleModeChanged build() {
      BusinessUnitApprovalRuleModeChanged result = new BusinessUnitApprovalRuleModeChanged();
      result.approvalRuleMode = this.approvalRuleMode;
      result.oldApprovalRuleMode = this.oldApprovalRuleMode;
      result.type = this.type;
      return result;
    }

    public Builder approvalRuleMode(BusinessUnitApprovalRuleMode approvalRuleMode) {
      this.approvalRuleMode = approvalRuleMode;
      return this;
    }

    public Builder oldApprovalRuleMode(BusinessUnitApprovalRuleMode oldApprovalRuleMode) {
      this.oldApprovalRuleMode = oldApprovalRuleMode;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
