package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitAssociateModeChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private BusinessUnitAssociateMode associateMode;

  private BusinessUnitAssociateMode oldAssociateMode;

  private String type;

  public BusinessUnitAssociateModeChanged() {
  }

  public BusinessUnitAssociateModeChanged(BusinessUnitAssociateMode associateMode,
      BusinessUnitAssociateMode oldAssociateMode, String type) {
    this.associateMode = associateMode;
    this.oldAssociateMode = oldAssociateMode;
    this.type = type;
  }

  public BusinessUnitAssociateMode getAssociateMode() {
    return associateMode;
  }

  public void setAssociateMode(BusinessUnitAssociateMode associateMode) {
    this.associateMode = associateMode;
  }

  public BusinessUnitAssociateMode getOldAssociateMode() {
    return oldAssociateMode;
  }

  public void setOldAssociateMode(BusinessUnitAssociateMode oldAssociateMode) {
    this.oldAssociateMode = oldAssociateMode;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitAssociateModeChanged{associateMode='" + associateMode + "', oldAssociateMode='" + oldAssociateMode + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitAssociateModeChanged that = (BusinessUnitAssociateModeChanged) o;
    return Objects.equals(associateMode, that.associateMode) &&
        Objects.equals(oldAssociateMode, that.oldAssociateMode) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associateMode, oldAssociateMode, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BusinessUnitAssociateMode associateMode;

    private BusinessUnitAssociateMode oldAssociateMode;

    private String type;

    public BusinessUnitAssociateModeChanged build() {
      BusinessUnitAssociateModeChanged result = new BusinessUnitAssociateModeChanged();
      result.associateMode = this.associateMode;
      result.oldAssociateMode = this.oldAssociateMode;
      result.type = this.type;
      return result;
    }

    public Builder associateMode(BusinessUnitAssociateMode associateMode) {
      this.associateMode = associateMode;
      return this;
    }

    public Builder oldAssociateMode(BusinessUnitAssociateMode oldAssociateMode) {
      this.oldAssociateMode = oldAssociateMode;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
