package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitAssociateRemoved implements com.commercetools.graphql.api.types.MessagePayload {
  private Associate associate;

  private String type;

  public BusinessUnitAssociateRemoved() {
  }

  public BusinessUnitAssociateRemoved(Associate associate, String type) {
    this.associate = associate;
    this.type = type;
  }

  public Associate getAssociate() {
    return associate;
  }

  public void setAssociate(Associate associate) {
    this.associate = associate;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitAssociateRemoved{associate='" + associate + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitAssociateRemoved that = (BusinessUnitAssociateRemoved) o;
    return Objects.equals(associate, that.associate) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associate, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Associate associate;

    private String type;

    public BusinessUnitAssociateRemoved build() {
      BusinessUnitAssociateRemoved result = new BusinessUnitAssociateRemoved();
      result.associate = this.associate;
      result.type = this.type;
      return result;
    }

    public Builder associate(Associate associate) {
      this.associate = associate;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
