package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitCustomFieldChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private String name;

  private JsonNode value;

  private JsonNode oldValue;

  private String type;

  public BusinessUnitCustomFieldChanged() {
  }

  public BusinessUnitCustomFieldChanged(String name, JsonNode value, JsonNode oldValue,
      String type) {
    this.name = name;
    this.value = value;
    this.oldValue = oldValue;
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonNode getValue() {
    return value;
  }

  public void setValue(JsonNode value) {
    this.value = value;
  }

  public JsonNode getOldValue() {
    return oldValue;
  }

  public void setOldValue(JsonNode oldValue) {
    this.oldValue = oldValue;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitCustomFieldChanged{name='" + name + "', value='" + value + "', oldValue='" + oldValue + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitCustomFieldChanged that = (BusinessUnitCustomFieldChanged) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(oldValue, that.oldValue) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, value, oldValue, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private JsonNode value;

    private JsonNode oldValue;

    private String type;

    public BusinessUnitCustomFieldChanged build() {
      BusinessUnitCustomFieldChanged result = new BusinessUnitCustomFieldChanged();
      result.name = this.name;
      result.value = this.value;
      result.oldValue = this.oldValue;
      result.type = this.type;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(JsonNode value) {
      this.value = value;
      return this;
    }

    public Builder oldValue(JsonNode oldValue) {
      this.oldValue = oldValue;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
