package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitCustomTypeSet implements com.commercetools.graphql.api.types.MessagePayload {
  private CustomFieldsType customFields;

  private String oldTypeId;

  private String type;

  public BusinessUnitCustomTypeSet() {
  }

  public BusinessUnitCustomTypeSet(CustomFieldsType customFields, String oldTypeId, String type) {
    this.customFields = customFields;
    this.oldTypeId = oldTypeId;
    this.type = type;
  }

  public CustomFieldsType getCustomFields() {
    return customFields;
  }

  public void setCustomFields(CustomFieldsType customFields) {
    this.customFields = customFields;
  }

  public String getOldTypeId() {
    return oldTypeId;
  }

  public void setOldTypeId(String oldTypeId) {
    this.oldTypeId = oldTypeId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitCustomTypeSet{customFields='" + customFields + "', oldTypeId='" + oldTypeId + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitCustomTypeSet that = (BusinessUnitCustomTypeSet) o;
    return Objects.equals(customFields, that.customFields) &&
        Objects.equals(oldTypeId, that.oldTypeId) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customFields, oldTypeId, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomFieldsType customFields;

    private String oldTypeId;

    private String type;

    public BusinessUnitCustomTypeSet build() {
      BusinessUnitCustomTypeSet result = new BusinessUnitCustomTypeSet();
      result.customFields = this.customFields;
      result.oldTypeId = this.oldTypeId;
      result.type = this.type;
      return result;
    }

    public Builder customFields(CustomFieldsType customFields) {
      this.customFields = customFields;
      return this;
    }

    public Builder oldTypeId(String oldTypeId) {
      this.oldTypeId = oldTypeId;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
