package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitDefaultBillingAddressSet implements com.commercetools.graphql.api.types.MessagePayload {
  private Address address;

  private String type;

  public BusinessUnitDefaultBillingAddressSet() {
  }

  public BusinessUnitDefaultBillingAddressSet(Address address, String type) {
    this.address = address;
    this.type = type;
  }

  public Address getAddress() {
    return address;
  }

  public void setAddress(Address address) {
    this.address = address;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitDefaultBillingAddressSet{address='" + address + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitDefaultBillingAddressSet that = (BusinessUnitDefaultBillingAddressSet) o;
    return Objects.equals(address, that.address) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Address address;

    private String type;

    public BusinessUnitDefaultBillingAddressSet build() {
      BusinessUnitDefaultBillingAddressSet result = new BusinessUnitDefaultBillingAddressSet();
      result.address = this.address;
      result.type = this.type;
      return result;
    }

    public Builder address(Address address) {
      this.address = address;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
