package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class BusinessUnitDraft {
  private String key;

  private String name;

  private String contactEmail;

  private List<AddressInput> addresses;

  /**
   * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
   */
  private Integer defaultBillingAddress;

  /**
   * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
   */
  private Integer defaultShippingAddress;

  /**
   * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
   */
  private List<Integer> shippingAddresses = Collections.emptyList();

  /**
   * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
   */
  private List<Integer> billingAddresses = Collections.emptyList();

  private CustomFieldsDraft custom;

  private BusinessUnitType unitType;

  private String storeMode;

  private ResourceIdentifierInput parentUnit;

  private List<ResourceIdentifierInput> stores;

  private List<AssociateDraft> associates;

  private BusinessUnitAssociateMode associateMode;

  private BusinessUnitApprovalRuleMode approvalRuleMode;

  public BusinessUnitDraft() {
  }

  public BusinessUnitDraft(String key, String name, String contactEmail,
      List<AddressInput> addresses, Integer defaultBillingAddress, Integer defaultShippingAddress,
      List<Integer> shippingAddresses, List<Integer> billingAddresses, CustomFieldsDraft custom,
      BusinessUnitType unitType, String storeMode, ResourceIdentifierInput parentUnit,
      List<ResourceIdentifierInput> stores, List<AssociateDraft> associates,
      BusinessUnitAssociateMode associateMode, BusinessUnitApprovalRuleMode approvalRuleMode) {
    this.key = key;
    this.name = name;
    this.contactEmail = contactEmail;
    this.addresses = addresses;
    this.defaultBillingAddress = defaultBillingAddress;
    this.defaultShippingAddress = defaultShippingAddress;
    this.shippingAddresses = shippingAddresses;
    this.billingAddresses = billingAddresses;
    this.custom = custom;
    this.unitType = unitType;
    this.storeMode = storeMode;
    this.parentUnit = parentUnit;
    this.stores = stores;
    this.associates = associates;
    this.associateMode = associateMode;
    this.approvalRuleMode = approvalRuleMode;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getContactEmail() {
    return contactEmail;
  }

  public void setContactEmail(String contactEmail) {
    this.contactEmail = contactEmail;
  }

  public List<AddressInput> getAddresses() {
    return addresses;
  }

  public void setAddresses(List<AddressInput> addresses) {
    this.addresses = addresses;
  }

  /**
   * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
   */
  public Integer getDefaultBillingAddress() {
    return defaultBillingAddress;
  }

  public void setDefaultBillingAddress(Integer defaultBillingAddress) {
    this.defaultBillingAddress = defaultBillingAddress;
  }

  /**
   * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
   */
  public Integer getDefaultShippingAddress() {
    return defaultShippingAddress;
  }

  public void setDefaultShippingAddress(Integer defaultShippingAddress) {
    this.defaultShippingAddress = defaultShippingAddress;
  }

  /**
   * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
   */
  public List<Integer> getShippingAddresses() {
    return shippingAddresses;
  }

  public void setShippingAddresses(List<Integer> shippingAddresses) {
    this.shippingAddresses = shippingAddresses;
  }

  /**
   * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
   */
  public List<Integer> getBillingAddresses() {
    return billingAddresses;
  }

  public void setBillingAddresses(List<Integer> billingAddresses) {
    this.billingAddresses = billingAddresses;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public BusinessUnitType getUnitType() {
    return unitType;
  }

  public void setUnitType(BusinessUnitType unitType) {
    this.unitType = unitType;
  }

  public String getStoreMode() {
    return storeMode;
  }

  public void setStoreMode(String storeMode) {
    this.storeMode = storeMode;
  }

  public ResourceIdentifierInput getParentUnit() {
    return parentUnit;
  }

  public void setParentUnit(ResourceIdentifierInput parentUnit) {
    this.parentUnit = parentUnit;
  }

  public List<ResourceIdentifierInput> getStores() {
    return stores;
  }

  public void setStores(List<ResourceIdentifierInput> stores) {
    this.stores = stores;
  }

  public List<AssociateDraft> getAssociates() {
    return associates;
  }

  public void setAssociates(List<AssociateDraft> associates) {
    this.associates = associates;
  }

  public BusinessUnitAssociateMode getAssociateMode() {
    return associateMode;
  }

  public void setAssociateMode(BusinessUnitAssociateMode associateMode) {
    this.associateMode = associateMode;
  }

  public BusinessUnitApprovalRuleMode getApprovalRuleMode() {
    return approvalRuleMode;
  }

  public void setApprovalRuleMode(BusinessUnitApprovalRuleMode approvalRuleMode) {
    this.approvalRuleMode = approvalRuleMode;
  }

  @Override
  public String toString() {
    return "BusinessUnitDraft{key='" + key + "', name='" + name + "', contactEmail='" + contactEmail + "', addresses='" + addresses + "', defaultBillingAddress='" + defaultBillingAddress + "', defaultShippingAddress='" + defaultShippingAddress + "', shippingAddresses='" + shippingAddresses + "', billingAddresses='" + billingAddresses + "', custom='" + custom + "', unitType='" + unitType + "', storeMode='" + storeMode + "', parentUnit='" + parentUnit + "', stores='" + stores + "', associates='" + associates + "', associateMode='" + associateMode + "', approvalRuleMode='" + approvalRuleMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitDraft that = (BusinessUnitDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(contactEmail, that.contactEmail) &&
        Objects.equals(addresses, that.addresses) &&
        Objects.equals(defaultBillingAddress, that.defaultBillingAddress) &&
        Objects.equals(defaultShippingAddress, that.defaultShippingAddress) &&
        Objects.equals(shippingAddresses, that.shippingAddresses) &&
        Objects.equals(billingAddresses, that.billingAddresses) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(unitType, that.unitType) &&
        Objects.equals(storeMode, that.storeMode) &&
        Objects.equals(parentUnit, that.parentUnit) &&
        Objects.equals(stores, that.stores) &&
        Objects.equals(associates, that.associates) &&
        Objects.equals(associateMode, that.associateMode) &&
        Objects.equals(approvalRuleMode, that.approvalRuleMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, contactEmail, addresses, defaultBillingAddress, defaultShippingAddress, shippingAddresses, billingAddresses, custom, unitType, storeMode, parentUnit, stores, associates, associateMode, approvalRuleMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String name;

    private String contactEmail;

    private List<AddressInput> addresses;

    /**
     * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
     */
    private Integer defaultBillingAddress;

    /**
     * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
     */
    private Integer defaultShippingAddress;

    /**
     * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
     */
    private List<Integer> shippingAddresses = Collections.emptyList();

    /**
     * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
     */
    private List<Integer> billingAddresses = Collections.emptyList();

    private CustomFieldsDraft custom;

    private BusinessUnitType unitType;

    private String storeMode;

    private ResourceIdentifierInput parentUnit;

    private List<ResourceIdentifierInput> stores;

    private List<AssociateDraft> associates;

    private BusinessUnitAssociateMode associateMode;

    private BusinessUnitApprovalRuleMode approvalRuleMode;

    public BusinessUnitDraft build() {
      BusinessUnitDraft result = new BusinessUnitDraft();
      result.key = this.key;
      result.name = this.name;
      result.contactEmail = this.contactEmail;
      result.addresses = this.addresses;
      result.defaultBillingAddress = this.defaultBillingAddress;
      result.defaultShippingAddress = this.defaultShippingAddress;
      result.shippingAddresses = this.shippingAddresses;
      result.billingAddresses = this.billingAddresses;
      result.custom = this.custom;
      result.unitType = this.unitType;
      result.storeMode = this.storeMode;
      result.parentUnit = this.parentUnit;
      result.stores = this.stores;
      result.associates = this.associates;
      result.associateMode = this.associateMode;
      result.approvalRuleMode = this.approvalRuleMode;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder contactEmail(String contactEmail) {
      this.contactEmail = contactEmail;
      return this;
    }

    public Builder addresses(List<AddressInput> addresses) {
      this.addresses = addresses;
      return this;
    }

    /**
     * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
     */
    public Builder defaultBillingAddress(Integer defaultBillingAddress) {
      this.defaultBillingAddress = defaultBillingAddress;
      return this;
    }

    /**
     * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
     */
    public Builder defaultShippingAddress(Integer defaultShippingAddress) {
      this.defaultShippingAddress = defaultShippingAddress;
      return this;
    }

    /**
     * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
     */
    public Builder shippingAddresses(List<Integer> shippingAddresses) {
      this.shippingAddresses = shippingAddresses;
      return this;
    }

    /**
     * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
     */
    public Builder billingAddresses(List<Integer> billingAddresses) {
      this.billingAddresses = billingAddresses;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder unitType(BusinessUnitType unitType) {
      this.unitType = unitType;
      return this;
    }

    public Builder storeMode(String storeMode) {
      this.storeMode = storeMode;
      return this;
    }

    public Builder parentUnit(ResourceIdentifierInput parentUnit) {
      this.parentUnit = parentUnit;
      return this;
    }

    public Builder stores(List<ResourceIdentifierInput> stores) {
      this.stores = stores;
      return this;
    }

    public Builder associates(List<AssociateDraft> associates) {
      this.associates = associates;
      return this;
    }

    public Builder associateMode(BusinessUnitAssociateMode associateMode) {
      this.associateMode = associateMode;
      return this;
    }

    public Builder approvalRuleMode(BusinessUnitApprovalRuleMode approvalRuleMode) {
      this.approvalRuleMode = approvalRuleMode;
      return this;
    }
  }
}
