package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitParentChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private BusinessUnit oldParentUnit;

  private BusinessUnit newParentUnit;

  private KeyReference oldParentUnitRef;

  private KeyReference newParentUnitRef;

  private String type;

  public BusinessUnitParentChanged() {
  }

  public BusinessUnitParentChanged(BusinessUnit oldParentUnit, BusinessUnit newParentUnit,
      KeyReference oldParentUnitRef, KeyReference newParentUnitRef, String type) {
    this.oldParentUnit = oldParentUnit;
    this.newParentUnit = newParentUnit;
    this.oldParentUnitRef = oldParentUnitRef;
    this.newParentUnitRef = newParentUnitRef;
    this.type = type;
  }

  public BusinessUnit getOldParentUnit() {
    return oldParentUnit;
  }

  public void setOldParentUnit(BusinessUnit oldParentUnit) {
    this.oldParentUnit = oldParentUnit;
  }

  public BusinessUnit getNewParentUnit() {
    return newParentUnit;
  }

  public void setNewParentUnit(BusinessUnit newParentUnit) {
    this.newParentUnit = newParentUnit;
  }

  public KeyReference getOldParentUnitRef() {
    return oldParentUnitRef;
  }

  public void setOldParentUnitRef(KeyReference oldParentUnitRef) {
    this.oldParentUnitRef = oldParentUnitRef;
  }

  public KeyReference getNewParentUnitRef() {
    return newParentUnitRef;
  }

  public void setNewParentUnitRef(KeyReference newParentUnitRef) {
    this.newParentUnitRef = newParentUnitRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitParentChanged{oldParentUnit='" + oldParentUnit + "', newParentUnit='" + newParentUnit + "', oldParentUnitRef='" + oldParentUnitRef + "', newParentUnitRef='" + newParentUnitRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitParentChanged that = (BusinessUnitParentChanged) o;
    return Objects.equals(oldParentUnit, that.oldParentUnit) &&
        Objects.equals(newParentUnit, that.newParentUnit) &&
        Objects.equals(oldParentUnitRef, that.oldParentUnitRef) &&
        Objects.equals(newParentUnitRef, that.newParentUnitRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldParentUnit, newParentUnit, oldParentUnitRef, newParentUnitRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BusinessUnit oldParentUnit;

    private BusinessUnit newParentUnit;

    private KeyReference oldParentUnitRef;

    private KeyReference newParentUnitRef;

    private String type;

    public BusinessUnitParentChanged build() {
      BusinessUnitParentChanged result = new BusinessUnitParentChanged();
      result.oldParentUnit = this.oldParentUnit;
      result.newParentUnit = this.newParentUnit;
      result.oldParentUnitRef = this.oldParentUnitRef;
      result.newParentUnitRef = this.newParentUnitRef;
      result.type = this.type;
      return result;
    }

    public Builder oldParentUnit(BusinessUnit oldParentUnit) {
      this.oldParentUnit = oldParentUnit;
      return this;
    }

    public Builder newParentUnit(BusinessUnit newParentUnit) {
      this.newParentUnit = newParentUnit;
      return this;
    }

    public Builder oldParentUnitRef(KeyReference oldParentUnitRef) {
      this.oldParentUnitRef = oldParentUnitRef;
      return this;
    }

    public Builder newParentUnitRef(KeyReference newParentUnitRef) {
      this.newParentUnitRef = newParentUnitRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
