package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class BusinessUnitSearchConfiguration {
  private BusinessUnitSearchStatus status;

  private OffsetDateTime lastModifiedAt;

  private Initiator lastModifiedBy;

  public BusinessUnitSearchConfiguration() {
  }

  public BusinessUnitSearchConfiguration(BusinessUnitSearchStatus status,
      OffsetDateTime lastModifiedAt, Initiator lastModifiedBy) {
    this.status = status;
    this.lastModifiedAt = lastModifiedAt;
    this.lastModifiedBy = lastModifiedBy;
  }

  public BusinessUnitSearchStatus getStatus() {
    return status;
  }

  public void setStatus(BusinessUnitSearchStatus status) {
    this.status = status;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "BusinessUnitSearchConfiguration{status='" + status + "', lastModifiedAt='" + lastModifiedAt + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitSearchConfiguration that = (BusinessUnitSearchConfiguration) o;
    return Objects.equals(status, that.status) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, lastModifiedAt, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BusinessUnitSearchStatus status;

    private OffsetDateTime lastModifiedAt;

    private Initiator lastModifiedBy;

    public BusinessUnitSearchConfiguration build() {
      BusinessUnitSearchConfiguration result = new BusinessUnitSearchConfiguration();
      result.status = this.status;
      result.lastModifiedAt = this.lastModifiedAt;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder status(BusinessUnitSearchStatus status) {
      this.status = status;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
