package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitStoresSet implements com.commercetools.graphql.api.types.MessagePayload {
  private List<Store> stores;

  private List<KeyReference> storesRef;

  private String type;

  public BusinessUnitStoresSet() {
  }

  public BusinessUnitStoresSet(List<Store> stores, List<KeyReference> storesRef, String type) {
    this.stores = stores;
    this.storesRef = storesRef;
    this.type = type;
  }

  public List<Store> getStores() {
    return stores;
  }

  public void setStores(List<Store> stores) {
    this.stores = stores;
  }

  public List<KeyReference> getStoresRef() {
    return storesRef;
  }

  public void setStoresRef(List<KeyReference> storesRef) {
    this.storesRef = storesRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitStoresSet{stores='" + stores + "', storesRef='" + storesRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitStoresSet that = (BusinessUnitStoresSet) o;
    return Objects.equals(stores, that.stores) &&
        Objects.equals(storesRef, that.storesRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stores, storesRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<Store> stores;

    private List<KeyReference> storesRef;

    private String type;

    public BusinessUnitStoresSet build() {
      BusinessUnitStoresSet result = new BusinessUnitStoresSet();
      result.stores = this.stores;
      result.storesRef = this.storesRef;
      result.type = this.type;
      return result;
    }

    public Builder stores(List<Store> stores) {
      this.stores = stores;
      return this;
    }

    public Builder storesRef(List<KeyReference> storesRef) {
      this.storesRef = storesRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
