package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class CartClassificationInput {
  private List<LocalizedEnumValueInput> values;

  public CartClassificationInput() {
  }

  public CartClassificationInput(List<LocalizedEnumValueInput> values) {
    this.values = values;
  }

  public List<LocalizedEnumValueInput> getValues() {
    return values;
  }

  public void setValues(List<LocalizedEnumValueInput> values) {
    this.values = values;
  }

  @Override
  public String toString() {
    return "CartClassificationInput{values='" + values + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartClassificationInput that = (CartClassificationInput) o;
    return Objects.equals(values, that.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(values);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedEnumValueInput> values;

    public CartClassificationInput build() {
      CartClassificationInput result = new CartClassificationInput();
      result.values = this.values;
      return result;
    }

    public Builder values(List<LocalizedEnumValueInput> values) {
      this.values = values;
      return this;
    }
  }
}
