package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CartClassificationType implements com.commercetools.graphql.api.types.ShippingRateInputType {
  private List<ShippingRateInputLocalizedEnumValue> values;

  private String type;

  public CartClassificationType() {
  }

  public CartClassificationType(List<ShippingRateInputLocalizedEnumValue> values, String type) {
    this.values = values;
    this.type = type;
  }

  public List<ShippingRateInputLocalizedEnumValue> getValues() {
    return values;
  }

  public void setValues(List<ShippingRateInputLocalizedEnumValue> values) {
    this.values = values;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CartClassificationType{values='" + values + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartClassificationType that = (CartClassificationType) o;
    return Objects.equals(values, that.values) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(values, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ShippingRateInputLocalizedEnumValue> values;

    private String type;

    public CartClassificationType build() {
      CartClassificationType result = new CartClassificationType();
      result.values = this.values;
      result.type = this.type;
      return result;
    }

    public Builder values(List<ShippingRateInputLocalizedEnumValue> values) {
      this.values = values;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
