package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CartDiscountCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private CartDiscount cartDiscount;

  private String type;

  public CartDiscountCreated() {
  }

  public CartDiscountCreated(CartDiscount cartDiscount, String type) {
    this.cartDiscount = cartDiscount;
    this.type = type;
  }

  public CartDiscount getCartDiscount() {
    return cartDiscount;
  }

  public void setCartDiscount(CartDiscount cartDiscount) {
    this.cartDiscount = cartDiscount;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CartDiscountCreated{cartDiscount='" + cartDiscount + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDiscountCreated that = (CartDiscountCreated) o;
    return Objects.equals(cartDiscount, that.cartDiscount) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cartDiscount, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CartDiscount cartDiscount;

    private String type;

    public CartDiscountCreated build() {
      CartDiscountCreated result = new CartDiscountCreated();
      result.cartDiscount = this.cartDiscount;
      result.type = this.type;
      return result;
    }

    public Builder cartDiscount(CartDiscount cartDiscount) {
      this.cartDiscount = cartDiscount;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
