package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class CartDiscountDraft {
  private CartDiscountValueInput value;

  private String cartPredicate;

  private CartDiscountTargetInput target;

  private String sortOrder;

  private List<LocalizedStringItemInputType> name;

  private List<LocalizedStringItemInputType> description;

  private OffsetDateTime validFrom;

  private OffsetDateTime validUntil;

  private StackingMode stackingMode = StackingMode.Stacking;

  private Boolean requiresDiscountCode = false;

  private Boolean isActive = true;

  private CustomFieldsDraft custom;

  private String key;

  private List<ResourceIdentifierInput> stores;

  public CartDiscountDraft() {
  }

  public CartDiscountDraft(CartDiscountValueInput value, String cartPredicate,
      CartDiscountTargetInput target, String sortOrder, List<LocalizedStringItemInputType> name,
      List<LocalizedStringItemInputType> description, OffsetDateTime validFrom,
      OffsetDateTime validUntil, StackingMode stackingMode, Boolean requiresDiscountCode,
      Boolean isActive, CustomFieldsDraft custom, String key,
      List<ResourceIdentifierInput> stores) {
    this.value = value;
    this.cartPredicate = cartPredicate;
    this.target = target;
    this.sortOrder = sortOrder;
    this.name = name;
    this.description = description;
    this.validFrom = validFrom;
    this.validUntil = validUntil;
    this.stackingMode = stackingMode;
    this.requiresDiscountCode = requiresDiscountCode;
    this.isActive = isActive;
    this.custom = custom;
    this.key = key;
    this.stores = stores;
  }

  public CartDiscountValueInput getValue() {
    return value;
  }

  public void setValue(CartDiscountValueInput value) {
    this.value = value;
  }

  public String getCartPredicate() {
    return cartPredicate;
  }

  public void setCartPredicate(String cartPredicate) {
    this.cartPredicate = cartPredicate;
  }

  public CartDiscountTargetInput getTarget() {
    return target;
  }

  public void setTarget(CartDiscountTargetInput target) {
    this.target = target;
  }

  public String getSortOrder() {
    return sortOrder;
  }

  public void setSortOrder(String sortOrder) {
    this.sortOrder = sortOrder;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public StackingMode getStackingMode() {
    return stackingMode;
  }

  public void setStackingMode(StackingMode stackingMode) {
    this.stackingMode = stackingMode;
  }

  public Boolean getRequiresDiscountCode() {
    return requiresDiscountCode;
  }

  public void setRequiresDiscountCode(Boolean requiresDiscountCode) {
    this.requiresDiscountCode = requiresDiscountCode;
  }

  public Boolean getIsActive() {
    return isActive;
  }

  public void setIsActive(Boolean isActive) {
    this.isActive = isActive;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<ResourceIdentifierInput> getStores() {
    return stores;
  }

  public void setStores(List<ResourceIdentifierInput> stores) {
    this.stores = stores;
  }

  @Override
  public String toString() {
    return "CartDiscountDraft{value='" + value + "', cartPredicate='" + cartPredicate + "', target='" + target + "', sortOrder='" + sortOrder + "', name='" + name + "', description='" + description + "', validFrom='" + validFrom + "', validUntil='" + validUntil + "', stackingMode='" + stackingMode + "', requiresDiscountCode='" + requiresDiscountCode + "', isActive='" + isActive + "', custom='" + custom + "', key='" + key + "', stores='" + stores + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDiscountDraft that = (CartDiscountDraft) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(cartPredicate, that.cartPredicate) &&
        Objects.equals(target, that.target) &&
        Objects.equals(sortOrder, that.sortOrder) &&
        Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(validUntil, that.validUntil) &&
        Objects.equals(stackingMode, that.stackingMode) &&
        Objects.equals(requiresDiscountCode, that.requiresDiscountCode) &&
        Objects.equals(isActive, that.isActive) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(key, that.key) &&
        Objects.equals(stores, that.stores);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, cartPredicate, target, sortOrder, name, description, validFrom, validUntil, stackingMode, requiresDiscountCode, isActive, custom, key, stores);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CartDiscountValueInput value;

    private String cartPredicate;

    private CartDiscountTargetInput target;

    private String sortOrder;

    private List<LocalizedStringItemInputType> name;

    private List<LocalizedStringItemInputType> description;

    private OffsetDateTime validFrom;

    private OffsetDateTime validUntil;

    private StackingMode stackingMode = StackingMode.Stacking;

    private Boolean requiresDiscountCode = false;

    private Boolean isActive = true;

    private CustomFieldsDraft custom;

    private String key;

    private List<ResourceIdentifierInput> stores;

    public CartDiscountDraft build() {
      CartDiscountDraft result = new CartDiscountDraft();
      result.value = this.value;
      result.cartPredicate = this.cartPredicate;
      result.target = this.target;
      result.sortOrder = this.sortOrder;
      result.name = this.name;
      result.description = this.description;
      result.validFrom = this.validFrom;
      result.validUntil = this.validUntil;
      result.stackingMode = this.stackingMode;
      result.requiresDiscountCode = this.requiresDiscountCode;
      result.isActive = this.isActive;
      result.custom = this.custom;
      result.key = this.key;
      result.stores = this.stores;
      return result;
    }

    public Builder value(CartDiscountValueInput value) {
      this.value = value;
      return this;
    }

    public Builder cartPredicate(String cartPredicate) {
      this.cartPredicate = cartPredicate;
      return this;
    }

    public Builder target(CartDiscountTargetInput target) {
      this.target = target;
      return this;
    }

    public Builder sortOrder(String sortOrder) {
      this.sortOrder = sortOrder;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }

    public Builder stackingMode(StackingMode stackingMode) {
      this.stackingMode = stackingMode;
      return this;
    }

    public Builder requiresDiscountCode(Boolean requiresDiscountCode) {
      this.requiresDiscountCode = requiresDiscountCode;
      return this;
    }

    public Builder isActive(Boolean isActive) {
      this.isActive = isActive;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder stores(List<ResourceIdentifierInput> stores) {
      this.stores = stores;
      return this;
    }
  }
}
