package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CartDiscountLimitWithCurrent implements com.commercetools.graphql.api.types.LimitWithCurrent {
  private Long limit;

  private Long current;

  public CartDiscountLimitWithCurrent() {
  }

  public CartDiscountLimitWithCurrent(Long limit, Long current) {
    this.limit = limit;
    this.current = current;
  }

  public Long getLimit() {
    return limit;
  }

  public void setLimit(Long limit) {
    this.limit = limit;
  }

  public Long getCurrent() {
    return current;
  }

  public void setCurrent(Long current) {
    this.current = current;
  }

  @Override
  public String toString() {
    return "CartDiscountLimitWithCurrent{limit='" + limit + "', current='" + current + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDiscountLimitWithCurrent that = (CartDiscountLimitWithCurrent) o;
    return Objects.equals(limit, that.limit) &&
        Objects.equals(current, that.current);
  }

  @Override
  public int hashCode() {
    return Objects.hash(limit, current);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Long limit;

    private Long current;

    public CartDiscountLimitWithCurrent build() {
      CartDiscountLimitWithCurrent result = new CartDiscountLimitWithCurrent();
      result.limit = this.limit;
      result.current = this.current;
      return result;
    }

    public Builder limit(Long limit) {
      this.limit = limit;
      return this;
    }

    public Builder current(Long current) {
      this.current = current;
      return this;
    }
  }
}
