package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CartDiscountLimitsProjection {
  private CartDiscountLimitWithCurrent totalActiveWithoutDiscountCodes;

  public CartDiscountLimitsProjection() {
  }

  public CartDiscountLimitsProjection(
      CartDiscountLimitWithCurrent totalActiveWithoutDiscountCodes) {
    this.totalActiveWithoutDiscountCodes = totalActiveWithoutDiscountCodes;
  }

  public CartDiscountLimitWithCurrent getTotalActiveWithoutDiscountCodes() {
    return totalActiveWithoutDiscountCodes;
  }

  public void setTotalActiveWithoutDiscountCodes(
      CartDiscountLimitWithCurrent totalActiveWithoutDiscountCodes) {
    this.totalActiveWithoutDiscountCodes = totalActiveWithoutDiscountCodes;
  }

  @Override
  public String toString() {
    return "CartDiscountLimitsProjection{totalActiveWithoutDiscountCodes='" + totalActiveWithoutDiscountCodes + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDiscountLimitsProjection that = (CartDiscountLimitsProjection) o;
    return Objects.equals(totalActiveWithoutDiscountCodes, that.totalActiveWithoutDiscountCodes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalActiveWithoutDiscountCodes);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CartDiscountLimitWithCurrent totalActiveWithoutDiscountCodes;

    public CartDiscountLimitsProjection build() {
      CartDiscountLimitsProjection result = new CartDiscountLimitsProjection();
      result.totalActiveWithoutDiscountCodes = this.totalActiveWithoutDiscountCodes;
      return result;
    }

    public Builder totalActiveWithoutDiscountCodes(
        CartDiscountLimitWithCurrent totalActiveWithoutDiscountCodes) {
      this.totalActiveWithoutDiscountCodes = totalActiveWithoutDiscountCodes;
      return this;
    }
  }
}
