package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CartDiscountPatternTarget implements com.commercetools.graphql.api.types.CartDiscountTarget {
  private List<PatternComponent> triggerPattern;

  private List<PatternComponent> targetPattern;

  private Integer maxOccurrence;

  private SelectionMode selectionMode;

  private String type;

  public CartDiscountPatternTarget() {
  }

  public CartDiscountPatternTarget(List<PatternComponent> triggerPattern,
      List<PatternComponent> targetPattern, Integer maxOccurrence, SelectionMode selectionMode,
      String type) {
    this.triggerPattern = triggerPattern;
    this.targetPattern = targetPattern;
    this.maxOccurrence = maxOccurrence;
    this.selectionMode = selectionMode;
    this.type = type;
  }

  public List<PatternComponent> getTriggerPattern() {
    return triggerPattern;
  }

  public void setTriggerPattern(List<PatternComponent> triggerPattern) {
    this.triggerPattern = triggerPattern;
  }

  public List<PatternComponent> getTargetPattern() {
    return targetPattern;
  }

  public void setTargetPattern(List<PatternComponent> targetPattern) {
    this.targetPattern = targetPattern;
  }

  public Integer getMaxOccurrence() {
    return maxOccurrence;
  }

  public void setMaxOccurrence(Integer maxOccurrence) {
    this.maxOccurrence = maxOccurrence;
  }

  public SelectionMode getSelectionMode() {
    return selectionMode;
  }

  public void setSelectionMode(SelectionMode selectionMode) {
    this.selectionMode = selectionMode;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CartDiscountPatternTarget{triggerPattern='" + triggerPattern + "', targetPattern='" + targetPattern + "', maxOccurrence='" + maxOccurrence + "', selectionMode='" + selectionMode + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDiscountPatternTarget that = (CartDiscountPatternTarget) o;
    return Objects.equals(triggerPattern, that.triggerPattern) &&
        Objects.equals(targetPattern, that.targetPattern) &&
        Objects.equals(maxOccurrence, that.maxOccurrence) &&
        Objects.equals(selectionMode, that.selectionMode) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(triggerPattern, targetPattern, maxOccurrence, selectionMode, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<PatternComponent> triggerPattern;

    private List<PatternComponent> targetPattern;

    private Integer maxOccurrence;

    private SelectionMode selectionMode;

    private String type;

    public CartDiscountPatternTarget build() {
      CartDiscountPatternTarget result = new CartDiscountPatternTarget();
      result.triggerPattern = this.triggerPattern;
      result.targetPattern = this.targetPattern;
      result.maxOccurrence = this.maxOccurrence;
      result.selectionMode = this.selectionMode;
      result.type = this.type;
      return result;
    }

    public Builder triggerPattern(List<PatternComponent> triggerPattern) {
      this.triggerPattern = triggerPattern;
      return this;
    }

    public Builder targetPattern(List<PatternComponent> targetPattern) {
      this.targetPattern = targetPattern;
      return this;
    }

    public Builder maxOccurrence(Integer maxOccurrence) {
      this.maxOccurrence = maxOccurrence;
      return this;
    }

    public Builder selectionMode(SelectionMode selectionMode) {
      this.selectionMode = selectionMode;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
