package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class CartDiscountPatternTargetInput {
  private List<PatternComponentInput> triggerPattern;

  private List<PatternComponentInput> targetPattern;

  private Integer maxOccurrence;

  private SelectionMode selectionMode;

  public CartDiscountPatternTargetInput() {
  }

  public CartDiscountPatternTargetInput(List<PatternComponentInput> triggerPattern,
      List<PatternComponentInput> targetPattern, Integer maxOccurrence,
      SelectionMode selectionMode) {
    this.triggerPattern = triggerPattern;
    this.targetPattern = targetPattern;
    this.maxOccurrence = maxOccurrence;
    this.selectionMode = selectionMode;
  }

  public List<PatternComponentInput> getTriggerPattern() {
    return triggerPattern;
  }

  public void setTriggerPattern(List<PatternComponentInput> triggerPattern) {
    this.triggerPattern = triggerPattern;
  }

  public List<PatternComponentInput> getTargetPattern() {
    return targetPattern;
  }

  public void setTargetPattern(List<PatternComponentInput> targetPattern) {
    this.targetPattern = targetPattern;
  }

  public Integer getMaxOccurrence() {
    return maxOccurrence;
  }

  public void setMaxOccurrence(Integer maxOccurrence) {
    this.maxOccurrence = maxOccurrence;
  }

  public SelectionMode getSelectionMode() {
    return selectionMode;
  }

  public void setSelectionMode(SelectionMode selectionMode) {
    this.selectionMode = selectionMode;
  }

  @Override
  public String toString() {
    return "CartDiscountPatternTargetInput{triggerPattern='" + triggerPattern + "', targetPattern='" + targetPattern + "', maxOccurrence='" + maxOccurrence + "', selectionMode='" + selectionMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDiscountPatternTargetInput that = (CartDiscountPatternTargetInput) o;
    return Objects.equals(triggerPattern, that.triggerPattern) &&
        Objects.equals(targetPattern, that.targetPattern) &&
        Objects.equals(maxOccurrence, that.maxOccurrence) &&
        Objects.equals(selectionMode, that.selectionMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(triggerPattern, targetPattern, maxOccurrence, selectionMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<PatternComponentInput> triggerPattern;

    private List<PatternComponentInput> targetPattern;

    private Integer maxOccurrence;

    private SelectionMode selectionMode;

    public CartDiscountPatternTargetInput build() {
      CartDiscountPatternTargetInput result = new CartDiscountPatternTargetInput();
      result.triggerPattern = this.triggerPattern;
      result.targetPattern = this.targetPattern;
      result.maxOccurrence = this.maxOccurrence;
      result.selectionMode = this.selectionMode;
      return result;
    }

    public Builder triggerPattern(List<PatternComponentInput> triggerPattern) {
      this.triggerPattern = triggerPattern;
      return this;
    }

    public Builder targetPattern(List<PatternComponentInput> targetPattern) {
      this.targetPattern = targetPattern;
      return this;
    }

    public Builder maxOccurrence(Integer maxOccurrence) {
      this.maxOccurrence = maxOccurrence;
      return this;
    }

    public Builder selectionMode(SelectionMode selectionMode) {
      this.selectionMode = selectionMode;
      return this;
    }
  }
}
