package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CartDiscountStoresSet implements com.commercetools.graphql.api.types.MessagePayload {
  private List<KeyReference> storesRef;

  private List<Store> stores;

  private String type;

  public CartDiscountStoresSet() {
  }

  public CartDiscountStoresSet(List<KeyReference> storesRef, List<Store> stores, String type) {
    this.storesRef = storesRef;
    this.stores = stores;
    this.type = type;
  }

  public List<KeyReference> getStoresRef() {
    return storesRef;
  }

  public void setStoresRef(List<KeyReference> storesRef) {
    this.storesRef = storesRef;
  }

  public List<Store> getStores() {
    return stores;
  }

  public void setStores(List<Store> stores) {
    this.stores = stores;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CartDiscountStoresSet{storesRef='" + storesRef + "', stores='" + stores + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDiscountStoresSet that = (CartDiscountStoresSet) o;
    return Objects.equals(storesRef, that.storesRef) &&
        Objects.equals(stores, that.stores) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(storesRef, stores, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<KeyReference> storesRef;

    private List<Store> stores;

    private String type;

    public CartDiscountStoresSet build() {
      CartDiscountStoresSet result = new CartDiscountStoresSet();
      result.storesRef = this.storesRef;
      result.stores = this.stores;
      result.type = this.type;
      return result;
    }

    public Builder storesRef(List<KeyReference> storesRef) {
      this.storesRef = storesRef;
      return this;
    }

    public Builder stores(List<Store> stores) {
      this.stores = stores;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
