package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = CartDiscountPatternTarget.class, name = "CartDiscountPatternTarget"),
    @JsonSubTypes.Type(value = CartDiscountTotalPriceTarget.class, name = "CartDiscountTotalPriceTarget"),
    @JsonSubTypes.Type(value = CustomLineItemsTarget.class, name = "CustomLineItemsTarget"),
    @JsonSubTypes.Type(value = LineItemsTarget.class, name = "LineItemsTarget"),
    @JsonSubTypes.Type(value = MultiBuyCustomLineItemsTarget.class, name = "MultiBuyCustomLineItemsTarget"),
    @JsonSubTypes.Type(value = MultiBuyLineItemsTarget.class, name = "MultiBuyLineItemsTarget"),
    @JsonSubTypes.Type(value = ShippingTarget.class, name = "ShippingTarget")
})
public interface CartDiscountTarget {
  String getType();

  void setType(String type);
}
