package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Currency;
import java.util.Objects;

public class CartDiscountValueBaseMoneyInput {
  private MoneyInput centPrecision;

  private HighPrecisionMoneyInput highPrecision;

  /**
   * CurrencyCode and centAmount are deprecated. Please use `Money`(centPrecision) or `HighPrecisionMoney`(highPrecision).
   */
  private Currency currencyCode;

  /**
   * CurrencyCode and centAmount are deprecated. Please use `Money`(centPrecision) or `HighPrecisionMoney`(highPrecision).
   */
  private Long centAmount;

  public CartDiscountValueBaseMoneyInput() {
  }

  public CartDiscountValueBaseMoneyInput(MoneyInput centPrecision,
      HighPrecisionMoneyInput highPrecision, Currency currencyCode, Long centAmount) {
    this.centPrecision = centPrecision;
    this.highPrecision = highPrecision;
    this.currencyCode = currencyCode;
    this.centAmount = centAmount;
  }

  public MoneyInput getCentPrecision() {
    return centPrecision;
  }

  public void setCentPrecision(MoneyInput centPrecision) {
    this.centPrecision = centPrecision;
  }

  public HighPrecisionMoneyInput getHighPrecision() {
    return highPrecision;
  }

  public void setHighPrecision(HighPrecisionMoneyInput highPrecision) {
    this.highPrecision = highPrecision;
  }

  /**
   * CurrencyCode and centAmount are deprecated. Please use `Money`(centPrecision) or `HighPrecisionMoney`(highPrecision).
   */
  public Currency getCurrencyCode() {
    return currencyCode;
  }

  public void setCurrencyCode(Currency currencyCode) {
    this.currencyCode = currencyCode;
  }

  /**
   * CurrencyCode and centAmount are deprecated. Please use `Money`(centPrecision) or `HighPrecisionMoney`(highPrecision).
   */
  public Long getCentAmount() {
    return centAmount;
  }

  public void setCentAmount(Long centAmount) {
    this.centAmount = centAmount;
  }

  @Override
  public String toString() {
    return "CartDiscountValueBaseMoneyInput{centPrecision='" + centPrecision + "', highPrecision='" + highPrecision + "', currencyCode='" + currencyCode + "', centAmount='" + centAmount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDiscountValueBaseMoneyInput that = (CartDiscountValueBaseMoneyInput) o;
    return Objects.equals(centPrecision, that.centPrecision) &&
        Objects.equals(highPrecision, that.highPrecision) &&
        Objects.equals(currencyCode, that.currencyCode) &&
        Objects.equals(centAmount, that.centAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(centPrecision, highPrecision, currencyCode, centAmount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MoneyInput centPrecision;

    private HighPrecisionMoneyInput highPrecision;

    /**
     * CurrencyCode and centAmount are deprecated. Please use `Money`(centPrecision) or `HighPrecisionMoney`(highPrecision).
     */
    private Currency currencyCode;

    /**
     * CurrencyCode and centAmount are deprecated. Please use `Money`(centPrecision) or `HighPrecisionMoney`(highPrecision).
     */
    private Long centAmount;

    public CartDiscountValueBaseMoneyInput build() {
      CartDiscountValueBaseMoneyInput result = new CartDiscountValueBaseMoneyInput();
      result.centPrecision = this.centPrecision;
      result.highPrecision = this.highPrecision;
      result.currencyCode = this.currencyCode;
      result.centAmount = this.centAmount;
      return result;
    }

    public Builder centPrecision(MoneyInput centPrecision) {
      this.centPrecision = centPrecision;
      return this;
    }

    public Builder highPrecision(HighPrecisionMoneyInput highPrecision) {
      this.highPrecision = highPrecision;
      return this;
    }

    /**
     * CurrencyCode and centAmount are deprecated. Please use `Money`(centPrecision) or `HighPrecisionMoney`(highPrecision).
     */
    public Builder currencyCode(Currency currencyCode) {
      this.currencyCode = currencyCode;
      return this;
    }

    /**
     * CurrencyCode and centAmount are deprecated. Please use `Money`(centPrecision) or `HighPrecisionMoney`(highPrecision).
     */
    public Builder centAmount(Long centAmount) {
      this.centAmount = centAmount;
      return this;
    }
  }
}
