package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CartDiscountValueInput {
  private RelativeDiscountValueInput relative;

  private AbsoluteDiscountValueInput absolute;

  private AbsoluteCartDiscountValueInput absoluteCart;

  private FixedPriceDiscountValueInput fixed;

  private FixedPriceCartDiscountValueInput fixedCart;

  private GiftLineItemValueInput giftLineItem;

  public CartDiscountValueInput() {
  }

  public CartDiscountValueInput(RelativeDiscountValueInput relative,
      AbsoluteDiscountValueInput absolute, AbsoluteCartDiscountValueInput absoluteCart,
      FixedPriceDiscountValueInput fixed, FixedPriceCartDiscountValueInput fixedCart,
      GiftLineItemValueInput giftLineItem) {
    this.relative = relative;
    this.absolute = absolute;
    this.absoluteCart = absoluteCart;
    this.fixed = fixed;
    this.fixedCart = fixedCart;
    this.giftLineItem = giftLineItem;
  }

  public RelativeDiscountValueInput getRelative() {
    return relative;
  }

  public void setRelative(RelativeDiscountValueInput relative) {
    this.relative = relative;
  }

  public AbsoluteDiscountValueInput getAbsolute() {
    return absolute;
  }

  public void setAbsolute(AbsoluteDiscountValueInput absolute) {
    this.absolute = absolute;
  }

  public AbsoluteCartDiscountValueInput getAbsoluteCart() {
    return absoluteCart;
  }

  public void setAbsoluteCart(AbsoluteCartDiscountValueInput absoluteCart) {
    this.absoluteCart = absoluteCart;
  }

  public FixedPriceDiscountValueInput getFixed() {
    return fixed;
  }

  public void setFixed(FixedPriceDiscountValueInput fixed) {
    this.fixed = fixed;
  }

  public FixedPriceCartDiscountValueInput getFixedCart() {
    return fixedCart;
  }

  public void setFixedCart(FixedPriceCartDiscountValueInput fixedCart) {
    this.fixedCart = fixedCart;
  }

  public GiftLineItemValueInput getGiftLineItem() {
    return giftLineItem;
  }

  public void setGiftLineItem(GiftLineItemValueInput giftLineItem) {
    this.giftLineItem = giftLineItem;
  }

  @Override
  public String toString() {
    return "CartDiscountValueInput{relative='" + relative + "', absolute='" + absolute + "', absoluteCart='" + absoluteCart + "', fixed='" + fixed + "', fixedCart='" + fixedCart + "', giftLineItem='" + giftLineItem + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDiscountValueInput that = (CartDiscountValueInput) o;
    return Objects.equals(relative, that.relative) &&
        Objects.equals(absolute, that.absolute) &&
        Objects.equals(absoluteCart, that.absoluteCart) &&
        Objects.equals(fixed, that.fixed) &&
        Objects.equals(fixedCart, that.fixedCart) &&
        Objects.equals(giftLineItem, that.giftLineItem);
  }

  @Override
  public int hashCode() {
    return Objects.hash(relative, absolute, absoluteCart, fixed, fixedCart, giftLineItem);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private RelativeDiscountValueInput relative;

    private AbsoluteDiscountValueInput absolute;

    private AbsoluteCartDiscountValueInput absoluteCart;

    private FixedPriceDiscountValueInput fixed;

    private FixedPriceCartDiscountValueInput fixedCart;

    private GiftLineItemValueInput giftLineItem;

    public CartDiscountValueInput build() {
      CartDiscountValueInput result = new CartDiscountValueInput();
      result.relative = this.relative;
      result.absolute = this.absolute;
      result.absoluteCart = this.absoluteCart;
      result.fixed = this.fixed;
      result.fixedCart = this.fixedCart;
      result.giftLineItem = this.giftLineItem;
      return result;
    }

    public Builder relative(RelativeDiscountValueInput relative) {
      this.relative = relative;
      return this;
    }

    public Builder absolute(AbsoluteDiscountValueInput absolute) {
      this.absolute = absolute;
      return this;
    }

    public Builder absoluteCart(AbsoluteCartDiscountValueInput absoluteCart) {
      this.absoluteCart = absoluteCart;
      return this;
    }

    public Builder fixed(FixedPriceDiscountValueInput fixed) {
      this.fixed = fixed;
      return this;
    }

    public Builder fixedCart(FixedPriceCartDiscountValueInput fixedCart) {
      this.fixedCart = fixedCart;
      return this;
    }

    public Builder giftLineItem(GiftLineItemValueInput giftLineItem) {
      this.giftLineItem = giftLineItem;
      return this;
    }
  }
}
