package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CartUpdateAction {
  private AddCartCustomLineItem addCustomLineItem;

  private AddCartCustomShippingMethod addCustomShippingMethod;

  private AddCartDiscountCode addDiscountCode;

  private AddCartItemShippingAddress addItemShippingAddress;

  private AddCartLineItem addLineItem;

  private AddCartPayment addPayment;

  private AddCartShippingMethod addShippingMethod;

  private AddCartShoppingList addShoppingList;

  private ApplyCartDeltaToCustomLineItemShippingDetailsTargets applyDeltaToCustomLineItemShippingDetailsTargets;

  private ApplyCartDeltaToLineItemShippingDetailsTargets applyDeltaToLineItemShippingDetailsTargets;

  private ChangeCartCustomLineItemMoney changeCustomLineItemMoney;

  private ChangeCartCustomLineItemPriceMode changeCustomLineItemPriceMode;

  private ChangeCartCustomLineItemQuantity changeCustomLineItemQuantity;

  private ChangeCartLineItemsOrder changeLineItemsOrder;

  private ChangeCartTaxCalculationMode changeTaxCalculationMode;

  private ChangeCartTaxMode changeTaxMode;

  private ChangeCartTaxRoundingMode changeTaxRoundingMode;

  private RecalculateCart recalculate;

  private RemoveCartCustomLineItem removeCustomLineItem;

  private RemoveCartDiscountCode removeDiscountCode;

  private RemoveCartItemShippingAddress removeItemShippingAddress;

  private RemoveCartLineItem removeLineItem;

  private RemoveCartPayment removePayment;

  private RemoveCartShippingMethod removeShippingMethod;

  private SetCartAnonymousId setAnonymousId;

  private SetCartBillingAddress setBillingAddress;

  private SetCartBillingAddressCustomField setBillingAddressCustomField;

  private SetCartBillingAddressCustomType setBillingAddressCustomType;

  private SetCartBusinessUnit setBusinessUnit;

  private SetCartKey setKey;

  private SetCartTotalTax setCartTotalTax;

  private SetCartCountry setCountry;

  private SetCartCustomField setCustomField;

  private SetCartCustomLineItemCustomField setCustomLineItemCustomField;

  private SetCartCustomLineItemCustomType setCustomLineItemCustomType;

  private SetCartCustomLineItemShippingDetails setCustomLineItemShippingDetails;

  private SetCartCustomLineItemTaxAmount setCustomLineItemTaxAmount;

  private SetCartCustomLineItemTaxRate setCustomLineItemTaxRate;

  private SetCartCustomShippingMethod setCustomShippingMethod;

  private SetCartCustomType setCustomType;

  private SetCartCustomerEmail setCustomerEmail;

  private SetCartCustomerGroup setCustomerGroup;

  private SetCartCustomerId setCustomerId;

  private SetCartDeleteDaysAfterLastModification setDeleteDaysAfterLastModification;

  private SetCartDirectDiscounts setDirectDiscounts;

  private SetCartItemShippingAddressCustomField setItemShippingAddressCustomField;

  private SetCartItemShippingAddressCustomType setItemShippingAddressCustomType;

  private SetCartLineItemCustomField setLineItemCustomField;

  private SetCartLineItemCustomType setLineItemCustomType;

  private SetCartLineItemDistributionChannel setLineItemDistributionChannel;

  private SetCartLineItemInventoryMode setLineItemInventoryMode;

  private SetCartLineItemPrice setLineItemPrice;

  private SetCartLineItemShippingDetails setLineItemShippingDetails;

  private SetCartLineItemSupplyChannel setLineItemSupplyChannel;

  private SetCartLineItemTaxAmount setLineItemTaxAmount;

  private SetCartLineItemTaxRate setLineItemTaxRate;

  private SetCartLineItemTotalPrice setLineItemTotalPrice;

  private SetCartLocale setLocale;

  private SetCartShippingAddress setShippingAddress;

  private SetCartShippingAddressCustomField setShippingAddressCustomField;

  private SetCartShippingAddressCustomType setShippingAddressCustomType;

  private SetCartShippingCustomField setShippingCustomField;

  private SetCartShippingCustomType setShippingCustomType;

  private SetCartShippingMethod setShippingMethod;

  private SetCartShippingMethodTaxAmount setShippingMethodTaxAmount;

  private SetCartShippingMethodTaxRate setShippingMethodTaxRate;

  private SetCartShippingRateInput setShippingRateInput;

  private UpdateCartItemShippingAddress updateItemShippingAddress;

  private FreezeCart freezeCart;

  private UnfreezeCart unfreezeCart;

  private ChangeCartLineItemQuantity changeLineItemQuantity;

  public CartUpdateAction() {
  }

  public CartUpdateAction(AddCartCustomLineItem addCustomLineItem,
      AddCartCustomShippingMethod addCustomShippingMethod, AddCartDiscountCode addDiscountCode,
      AddCartItemShippingAddress addItemShippingAddress, AddCartLineItem addLineItem,
      AddCartPayment addPayment, AddCartShippingMethod addShippingMethod,
      AddCartShoppingList addShoppingList,
      ApplyCartDeltaToCustomLineItemShippingDetailsTargets applyDeltaToCustomLineItemShippingDetailsTargets,
      ApplyCartDeltaToLineItemShippingDetailsTargets applyDeltaToLineItemShippingDetailsTargets,
      ChangeCartCustomLineItemMoney changeCustomLineItemMoney,
      ChangeCartCustomLineItemPriceMode changeCustomLineItemPriceMode,
      ChangeCartCustomLineItemQuantity changeCustomLineItemQuantity,
      ChangeCartLineItemsOrder changeLineItemsOrder,
      ChangeCartTaxCalculationMode changeTaxCalculationMode, ChangeCartTaxMode changeTaxMode,
      ChangeCartTaxRoundingMode changeTaxRoundingMode, RecalculateCart recalculate,
      RemoveCartCustomLineItem removeCustomLineItem, RemoveCartDiscountCode removeDiscountCode,
      RemoveCartItemShippingAddress removeItemShippingAddress, RemoveCartLineItem removeLineItem,
      RemoveCartPayment removePayment, RemoveCartShippingMethod removeShippingMethod,
      SetCartAnonymousId setAnonymousId, SetCartBillingAddress setBillingAddress,
      SetCartBillingAddressCustomField setBillingAddressCustomField,
      SetCartBillingAddressCustomType setBillingAddressCustomType,
      SetCartBusinessUnit setBusinessUnit, SetCartKey setKey, SetCartTotalTax setCartTotalTax,
      SetCartCountry setCountry, SetCartCustomField setCustomField,
      SetCartCustomLineItemCustomField setCustomLineItemCustomField,
      SetCartCustomLineItemCustomType setCustomLineItemCustomType,
      SetCartCustomLineItemShippingDetails setCustomLineItemShippingDetails,
      SetCartCustomLineItemTaxAmount setCustomLineItemTaxAmount,
      SetCartCustomLineItemTaxRate setCustomLineItemTaxRate,
      SetCartCustomShippingMethod setCustomShippingMethod, SetCartCustomType setCustomType,
      SetCartCustomerEmail setCustomerEmail, SetCartCustomerGroup setCustomerGroup,
      SetCartCustomerId setCustomerId,
      SetCartDeleteDaysAfterLastModification setDeleteDaysAfterLastModification,
      SetCartDirectDiscounts setDirectDiscounts,
      SetCartItemShippingAddressCustomField setItemShippingAddressCustomField,
      SetCartItemShippingAddressCustomType setItemShippingAddressCustomType,
      SetCartLineItemCustomField setLineItemCustomField,
      SetCartLineItemCustomType setLineItemCustomType,
      SetCartLineItemDistributionChannel setLineItemDistributionChannel,
      SetCartLineItemInventoryMode setLineItemInventoryMode, SetCartLineItemPrice setLineItemPrice,
      SetCartLineItemShippingDetails setLineItemShippingDetails,
      SetCartLineItemSupplyChannel setLineItemSupplyChannel,
      SetCartLineItemTaxAmount setLineItemTaxAmount, SetCartLineItemTaxRate setLineItemTaxRate,
      SetCartLineItemTotalPrice setLineItemTotalPrice, SetCartLocale setLocale,
      SetCartShippingAddress setShippingAddress,
      SetCartShippingAddressCustomField setShippingAddressCustomField,
      SetCartShippingAddressCustomType setShippingAddressCustomType,
      SetCartShippingCustomField setShippingCustomField,
      SetCartShippingCustomType setShippingCustomType, SetCartShippingMethod setShippingMethod,
      SetCartShippingMethodTaxAmount setShippingMethodTaxAmount,
      SetCartShippingMethodTaxRate setShippingMethodTaxRate,
      SetCartShippingRateInput setShippingRateInput,
      UpdateCartItemShippingAddress updateItemShippingAddress, FreezeCart freezeCart,
      UnfreezeCart unfreezeCart, ChangeCartLineItemQuantity changeLineItemQuantity) {
    this.addCustomLineItem = addCustomLineItem;
    this.addCustomShippingMethod = addCustomShippingMethod;
    this.addDiscountCode = addDiscountCode;
    this.addItemShippingAddress = addItemShippingAddress;
    this.addLineItem = addLineItem;
    this.addPayment = addPayment;
    this.addShippingMethod = addShippingMethod;
    this.addShoppingList = addShoppingList;
    this.applyDeltaToCustomLineItemShippingDetailsTargets = applyDeltaToCustomLineItemShippingDetailsTargets;
    this.applyDeltaToLineItemShippingDetailsTargets = applyDeltaToLineItemShippingDetailsTargets;
    this.changeCustomLineItemMoney = changeCustomLineItemMoney;
    this.changeCustomLineItemPriceMode = changeCustomLineItemPriceMode;
    this.changeCustomLineItemQuantity = changeCustomLineItemQuantity;
    this.changeLineItemsOrder = changeLineItemsOrder;
    this.changeTaxCalculationMode = changeTaxCalculationMode;
    this.changeTaxMode = changeTaxMode;
    this.changeTaxRoundingMode = changeTaxRoundingMode;
    this.recalculate = recalculate;
    this.removeCustomLineItem = removeCustomLineItem;
    this.removeDiscountCode = removeDiscountCode;
    this.removeItemShippingAddress = removeItemShippingAddress;
    this.removeLineItem = removeLineItem;
    this.removePayment = removePayment;
    this.removeShippingMethod = removeShippingMethod;
    this.setAnonymousId = setAnonymousId;
    this.setBillingAddress = setBillingAddress;
    this.setBillingAddressCustomField = setBillingAddressCustomField;
    this.setBillingAddressCustomType = setBillingAddressCustomType;
    this.setBusinessUnit = setBusinessUnit;
    this.setKey = setKey;
    this.setCartTotalTax = setCartTotalTax;
    this.setCountry = setCountry;
    this.setCustomField = setCustomField;
    this.setCustomLineItemCustomField = setCustomLineItemCustomField;
    this.setCustomLineItemCustomType = setCustomLineItemCustomType;
    this.setCustomLineItemShippingDetails = setCustomLineItemShippingDetails;
    this.setCustomLineItemTaxAmount = setCustomLineItemTaxAmount;
    this.setCustomLineItemTaxRate = setCustomLineItemTaxRate;
    this.setCustomShippingMethod = setCustomShippingMethod;
    this.setCustomType = setCustomType;
    this.setCustomerEmail = setCustomerEmail;
    this.setCustomerGroup = setCustomerGroup;
    this.setCustomerId = setCustomerId;
    this.setDeleteDaysAfterLastModification = setDeleteDaysAfterLastModification;
    this.setDirectDiscounts = setDirectDiscounts;
    this.setItemShippingAddressCustomField = setItemShippingAddressCustomField;
    this.setItemShippingAddressCustomType = setItemShippingAddressCustomType;
    this.setLineItemCustomField = setLineItemCustomField;
    this.setLineItemCustomType = setLineItemCustomType;
    this.setLineItemDistributionChannel = setLineItemDistributionChannel;
    this.setLineItemInventoryMode = setLineItemInventoryMode;
    this.setLineItemPrice = setLineItemPrice;
    this.setLineItemShippingDetails = setLineItemShippingDetails;
    this.setLineItemSupplyChannel = setLineItemSupplyChannel;
    this.setLineItemTaxAmount = setLineItemTaxAmount;
    this.setLineItemTaxRate = setLineItemTaxRate;
    this.setLineItemTotalPrice = setLineItemTotalPrice;
    this.setLocale = setLocale;
    this.setShippingAddress = setShippingAddress;
    this.setShippingAddressCustomField = setShippingAddressCustomField;
    this.setShippingAddressCustomType = setShippingAddressCustomType;
    this.setShippingCustomField = setShippingCustomField;
    this.setShippingCustomType = setShippingCustomType;
    this.setShippingMethod = setShippingMethod;
    this.setShippingMethodTaxAmount = setShippingMethodTaxAmount;
    this.setShippingMethodTaxRate = setShippingMethodTaxRate;
    this.setShippingRateInput = setShippingRateInput;
    this.updateItemShippingAddress = updateItemShippingAddress;
    this.freezeCart = freezeCart;
    this.unfreezeCart = unfreezeCart;
    this.changeLineItemQuantity = changeLineItemQuantity;
  }

  public AddCartCustomLineItem getAddCustomLineItem() {
    return addCustomLineItem;
  }

  public void setAddCustomLineItem(AddCartCustomLineItem addCustomLineItem) {
    this.addCustomLineItem = addCustomLineItem;
  }

  public AddCartCustomShippingMethod getAddCustomShippingMethod() {
    return addCustomShippingMethod;
  }

  public void setAddCustomShippingMethod(AddCartCustomShippingMethod addCustomShippingMethod) {
    this.addCustomShippingMethod = addCustomShippingMethod;
  }

  public AddCartDiscountCode getAddDiscountCode() {
    return addDiscountCode;
  }

  public void setAddDiscountCode(AddCartDiscountCode addDiscountCode) {
    this.addDiscountCode = addDiscountCode;
  }

  public AddCartItemShippingAddress getAddItemShippingAddress() {
    return addItemShippingAddress;
  }

  public void setAddItemShippingAddress(AddCartItemShippingAddress addItemShippingAddress) {
    this.addItemShippingAddress = addItemShippingAddress;
  }

  public AddCartLineItem getAddLineItem() {
    return addLineItem;
  }

  public void setAddLineItem(AddCartLineItem addLineItem) {
    this.addLineItem = addLineItem;
  }

  public AddCartPayment getAddPayment() {
    return addPayment;
  }

  public void setAddPayment(AddCartPayment addPayment) {
    this.addPayment = addPayment;
  }

  public AddCartShippingMethod getAddShippingMethod() {
    return addShippingMethod;
  }

  public void setAddShippingMethod(AddCartShippingMethod addShippingMethod) {
    this.addShippingMethod = addShippingMethod;
  }

  public AddCartShoppingList getAddShoppingList() {
    return addShoppingList;
  }

  public void setAddShoppingList(AddCartShoppingList addShoppingList) {
    this.addShoppingList = addShoppingList;
  }

  public ApplyCartDeltaToCustomLineItemShippingDetailsTargets getApplyDeltaToCustomLineItemShippingDetailsTargets(
      ) {
    return applyDeltaToCustomLineItemShippingDetailsTargets;
  }

  public void setApplyDeltaToCustomLineItemShippingDetailsTargets(
      ApplyCartDeltaToCustomLineItemShippingDetailsTargets applyDeltaToCustomLineItemShippingDetailsTargets) {
    this.applyDeltaToCustomLineItemShippingDetailsTargets = applyDeltaToCustomLineItemShippingDetailsTargets;
  }

  public ApplyCartDeltaToLineItemShippingDetailsTargets getApplyDeltaToLineItemShippingDetailsTargets(
      ) {
    return applyDeltaToLineItemShippingDetailsTargets;
  }

  public void setApplyDeltaToLineItemShippingDetailsTargets(
      ApplyCartDeltaToLineItemShippingDetailsTargets applyDeltaToLineItemShippingDetailsTargets) {
    this.applyDeltaToLineItemShippingDetailsTargets = applyDeltaToLineItemShippingDetailsTargets;
  }

  public ChangeCartCustomLineItemMoney getChangeCustomLineItemMoney() {
    return changeCustomLineItemMoney;
  }

  public void setChangeCustomLineItemMoney(
      ChangeCartCustomLineItemMoney changeCustomLineItemMoney) {
    this.changeCustomLineItemMoney = changeCustomLineItemMoney;
  }

  public ChangeCartCustomLineItemPriceMode getChangeCustomLineItemPriceMode() {
    return changeCustomLineItemPriceMode;
  }

  public void setChangeCustomLineItemPriceMode(
      ChangeCartCustomLineItemPriceMode changeCustomLineItemPriceMode) {
    this.changeCustomLineItemPriceMode = changeCustomLineItemPriceMode;
  }

  public ChangeCartCustomLineItemQuantity getChangeCustomLineItemQuantity() {
    return changeCustomLineItemQuantity;
  }

  public void setChangeCustomLineItemQuantity(
      ChangeCartCustomLineItemQuantity changeCustomLineItemQuantity) {
    this.changeCustomLineItemQuantity = changeCustomLineItemQuantity;
  }

  public ChangeCartLineItemsOrder getChangeLineItemsOrder() {
    return changeLineItemsOrder;
  }

  public void setChangeLineItemsOrder(ChangeCartLineItemsOrder changeLineItemsOrder) {
    this.changeLineItemsOrder = changeLineItemsOrder;
  }

  public ChangeCartTaxCalculationMode getChangeTaxCalculationMode() {
    return changeTaxCalculationMode;
  }

  public void setChangeTaxCalculationMode(ChangeCartTaxCalculationMode changeTaxCalculationMode) {
    this.changeTaxCalculationMode = changeTaxCalculationMode;
  }

  public ChangeCartTaxMode getChangeTaxMode() {
    return changeTaxMode;
  }

  public void setChangeTaxMode(ChangeCartTaxMode changeTaxMode) {
    this.changeTaxMode = changeTaxMode;
  }

  public ChangeCartTaxRoundingMode getChangeTaxRoundingMode() {
    return changeTaxRoundingMode;
  }

  public void setChangeTaxRoundingMode(ChangeCartTaxRoundingMode changeTaxRoundingMode) {
    this.changeTaxRoundingMode = changeTaxRoundingMode;
  }

  public RecalculateCart getRecalculate() {
    return recalculate;
  }

  public void setRecalculate(RecalculateCart recalculate) {
    this.recalculate = recalculate;
  }

  public RemoveCartCustomLineItem getRemoveCustomLineItem() {
    return removeCustomLineItem;
  }

  public void setRemoveCustomLineItem(RemoveCartCustomLineItem removeCustomLineItem) {
    this.removeCustomLineItem = removeCustomLineItem;
  }

  public RemoveCartDiscountCode getRemoveDiscountCode() {
    return removeDiscountCode;
  }

  public void setRemoveDiscountCode(RemoveCartDiscountCode removeDiscountCode) {
    this.removeDiscountCode = removeDiscountCode;
  }

  public RemoveCartItemShippingAddress getRemoveItemShippingAddress() {
    return removeItemShippingAddress;
  }

  public void setRemoveItemShippingAddress(
      RemoveCartItemShippingAddress removeItemShippingAddress) {
    this.removeItemShippingAddress = removeItemShippingAddress;
  }

  public RemoveCartLineItem getRemoveLineItem() {
    return removeLineItem;
  }

  public void setRemoveLineItem(RemoveCartLineItem removeLineItem) {
    this.removeLineItem = removeLineItem;
  }

  public RemoveCartPayment getRemovePayment() {
    return removePayment;
  }

  public void setRemovePayment(RemoveCartPayment removePayment) {
    this.removePayment = removePayment;
  }

  public RemoveCartShippingMethod getRemoveShippingMethod() {
    return removeShippingMethod;
  }

  public void setRemoveShippingMethod(RemoveCartShippingMethod removeShippingMethod) {
    this.removeShippingMethod = removeShippingMethod;
  }

  public SetCartAnonymousId getSetAnonymousId() {
    return setAnonymousId;
  }

  public void setSetAnonymousId(SetCartAnonymousId setAnonymousId) {
    this.setAnonymousId = setAnonymousId;
  }

  public SetCartBillingAddress getSetBillingAddress() {
    return setBillingAddress;
  }

  public void setSetBillingAddress(SetCartBillingAddress setBillingAddress) {
    this.setBillingAddress = setBillingAddress;
  }

  public SetCartBillingAddressCustomField getSetBillingAddressCustomField() {
    return setBillingAddressCustomField;
  }

  public void setSetBillingAddressCustomField(
      SetCartBillingAddressCustomField setBillingAddressCustomField) {
    this.setBillingAddressCustomField = setBillingAddressCustomField;
  }

  public SetCartBillingAddressCustomType getSetBillingAddressCustomType() {
    return setBillingAddressCustomType;
  }

  public void setSetBillingAddressCustomType(
      SetCartBillingAddressCustomType setBillingAddressCustomType) {
    this.setBillingAddressCustomType = setBillingAddressCustomType;
  }

  public SetCartBusinessUnit getSetBusinessUnit() {
    return setBusinessUnit;
  }

  public void setSetBusinessUnit(SetCartBusinessUnit setBusinessUnit) {
    this.setBusinessUnit = setBusinessUnit;
  }

  public SetCartKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetCartKey setKey) {
    this.setKey = setKey;
  }

  public SetCartTotalTax getSetCartTotalTax() {
    return setCartTotalTax;
  }

  public void setSetCartTotalTax(SetCartTotalTax setCartTotalTax) {
    this.setCartTotalTax = setCartTotalTax;
  }

  public SetCartCountry getSetCountry() {
    return setCountry;
  }

  public void setSetCountry(SetCartCountry setCountry) {
    this.setCountry = setCountry;
  }

  public SetCartCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetCartCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetCartCustomLineItemCustomField getSetCustomLineItemCustomField() {
    return setCustomLineItemCustomField;
  }

  public void setSetCustomLineItemCustomField(
      SetCartCustomLineItemCustomField setCustomLineItemCustomField) {
    this.setCustomLineItemCustomField = setCustomLineItemCustomField;
  }

  public SetCartCustomLineItemCustomType getSetCustomLineItemCustomType() {
    return setCustomLineItemCustomType;
  }

  public void setSetCustomLineItemCustomType(
      SetCartCustomLineItemCustomType setCustomLineItemCustomType) {
    this.setCustomLineItemCustomType = setCustomLineItemCustomType;
  }

  public SetCartCustomLineItemShippingDetails getSetCustomLineItemShippingDetails() {
    return setCustomLineItemShippingDetails;
  }

  public void setSetCustomLineItemShippingDetails(
      SetCartCustomLineItemShippingDetails setCustomLineItemShippingDetails) {
    this.setCustomLineItemShippingDetails = setCustomLineItemShippingDetails;
  }

  public SetCartCustomLineItemTaxAmount getSetCustomLineItemTaxAmount() {
    return setCustomLineItemTaxAmount;
  }

  public void setSetCustomLineItemTaxAmount(
      SetCartCustomLineItemTaxAmount setCustomLineItemTaxAmount) {
    this.setCustomLineItemTaxAmount = setCustomLineItemTaxAmount;
  }

  public SetCartCustomLineItemTaxRate getSetCustomLineItemTaxRate() {
    return setCustomLineItemTaxRate;
  }

  public void setSetCustomLineItemTaxRate(SetCartCustomLineItemTaxRate setCustomLineItemTaxRate) {
    this.setCustomLineItemTaxRate = setCustomLineItemTaxRate;
  }

  public SetCartCustomShippingMethod getSetCustomShippingMethod() {
    return setCustomShippingMethod;
  }

  public void setSetCustomShippingMethod(SetCartCustomShippingMethod setCustomShippingMethod) {
    this.setCustomShippingMethod = setCustomShippingMethod;
  }

  public SetCartCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetCartCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetCartCustomerEmail getSetCustomerEmail() {
    return setCustomerEmail;
  }

  public void setSetCustomerEmail(SetCartCustomerEmail setCustomerEmail) {
    this.setCustomerEmail = setCustomerEmail;
  }

  public SetCartCustomerGroup getSetCustomerGroup() {
    return setCustomerGroup;
  }

  public void setSetCustomerGroup(SetCartCustomerGroup setCustomerGroup) {
    this.setCustomerGroup = setCustomerGroup;
  }

  public SetCartCustomerId getSetCustomerId() {
    return setCustomerId;
  }

  public void setSetCustomerId(SetCartCustomerId setCustomerId) {
    this.setCustomerId = setCustomerId;
  }

  public SetCartDeleteDaysAfterLastModification getSetDeleteDaysAfterLastModification() {
    return setDeleteDaysAfterLastModification;
  }

  public void setSetDeleteDaysAfterLastModification(
      SetCartDeleteDaysAfterLastModification setDeleteDaysAfterLastModification) {
    this.setDeleteDaysAfterLastModification = setDeleteDaysAfterLastModification;
  }

  public SetCartDirectDiscounts getSetDirectDiscounts() {
    return setDirectDiscounts;
  }

  public void setSetDirectDiscounts(SetCartDirectDiscounts setDirectDiscounts) {
    this.setDirectDiscounts = setDirectDiscounts;
  }

  public SetCartItemShippingAddressCustomField getSetItemShippingAddressCustomField() {
    return setItemShippingAddressCustomField;
  }

  public void setSetItemShippingAddressCustomField(
      SetCartItemShippingAddressCustomField setItemShippingAddressCustomField) {
    this.setItemShippingAddressCustomField = setItemShippingAddressCustomField;
  }

  public SetCartItemShippingAddressCustomType getSetItemShippingAddressCustomType() {
    return setItemShippingAddressCustomType;
  }

  public void setSetItemShippingAddressCustomType(
      SetCartItemShippingAddressCustomType setItemShippingAddressCustomType) {
    this.setItemShippingAddressCustomType = setItemShippingAddressCustomType;
  }

  public SetCartLineItemCustomField getSetLineItemCustomField() {
    return setLineItemCustomField;
  }

  public void setSetLineItemCustomField(SetCartLineItemCustomField setLineItemCustomField) {
    this.setLineItemCustomField = setLineItemCustomField;
  }

  public SetCartLineItemCustomType getSetLineItemCustomType() {
    return setLineItemCustomType;
  }

  public void setSetLineItemCustomType(SetCartLineItemCustomType setLineItemCustomType) {
    this.setLineItemCustomType = setLineItemCustomType;
  }

  public SetCartLineItemDistributionChannel getSetLineItemDistributionChannel() {
    return setLineItemDistributionChannel;
  }

  public void setSetLineItemDistributionChannel(
      SetCartLineItemDistributionChannel setLineItemDistributionChannel) {
    this.setLineItemDistributionChannel = setLineItemDistributionChannel;
  }

  public SetCartLineItemInventoryMode getSetLineItemInventoryMode() {
    return setLineItemInventoryMode;
  }

  public void setSetLineItemInventoryMode(SetCartLineItemInventoryMode setLineItemInventoryMode) {
    this.setLineItemInventoryMode = setLineItemInventoryMode;
  }

  public SetCartLineItemPrice getSetLineItemPrice() {
    return setLineItemPrice;
  }

  public void setSetLineItemPrice(SetCartLineItemPrice setLineItemPrice) {
    this.setLineItemPrice = setLineItemPrice;
  }

  public SetCartLineItemShippingDetails getSetLineItemShippingDetails() {
    return setLineItemShippingDetails;
  }

  public void setSetLineItemShippingDetails(
      SetCartLineItemShippingDetails setLineItemShippingDetails) {
    this.setLineItemShippingDetails = setLineItemShippingDetails;
  }

  public SetCartLineItemSupplyChannel getSetLineItemSupplyChannel() {
    return setLineItemSupplyChannel;
  }

  public void setSetLineItemSupplyChannel(SetCartLineItemSupplyChannel setLineItemSupplyChannel) {
    this.setLineItemSupplyChannel = setLineItemSupplyChannel;
  }

  public SetCartLineItemTaxAmount getSetLineItemTaxAmount() {
    return setLineItemTaxAmount;
  }

  public void setSetLineItemTaxAmount(SetCartLineItemTaxAmount setLineItemTaxAmount) {
    this.setLineItemTaxAmount = setLineItemTaxAmount;
  }

  public SetCartLineItemTaxRate getSetLineItemTaxRate() {
    return setLineItemTaxRate;
  }

  public void setSetLineItemTaxRate(SetCartLineItemTaxRate setLineItemTaxRate) {
    this.setLineItemTaxRate = setLineItemTaxRate;
  }

  public SetCartLineItemTotalPrice getSetLineItemTotalPrice() {
    return setLineItemTotalPrice;
  }

  public void setSetLineItemTotalPrice(SetCartLineItemTotalPrice setLineItemTotalPrice) {
    this.setLineItemTotalPrice = setLineItemTotalPrice;
  }

  public SetCartLocale getSetLocale() {
    return setLocale;
  }

  public void setSetLocale(SetCartLocale setLocale) {
    this.setLocale = setLocale;
  }

  public SetCartShippingAddress getSetShippingAddress() {
    return setShippingAddress;
  }

  public void setSetShippingAddress(SetCartShippingAddress setShippingAddress) {
    this.setShippingAddress = setShippingAddress;
  }

  public SetCartShippingAddressCustomField getSetShippingAddressCustomField() {
    return setShippingAddressCustomField;
  }

  public void setSetShippingAddressCustomField(
      SetCartShippingAddressCustomField setShippingAddressCustomField) {
    this.setShippingAddressCustomField = setShippingAddressCustomField;
  }

  public SetCartShippingAddressCustomType getSetShippingAddressCustomType() {
    return setShippingAddressCustomType;
  }

  public void setSetShippingAddressCustomType(
      SetCartShippingAddressCustomType setShippingAddressCustomType) {
    this.setShippingAddressCustomType = setShippingAddressCustomType;
  }

  public SetCartShippingCustomField getSetShippingCustomField() {
    return setShippingCustomField;
  }

  public void setSetShippingCustomField(SetCartShippingCustomField setShippingCustomField) {
    this.setShippingCustomField = setShippingCustomField;
  }

  public SetCartShippingCustomType getSetShippingCustomType() {
    return setShippingCustomType;
  }

  public void setSetShippingCustomType(SetCartShippingCustomType setShippingCustomType) {
    this.setShippingCustomType = setShippingCustomType;
  }

  public SetCartShippingMethod getSetShippingMethod() {
    return setShippingMethod;
  }

  public void setSetShippingMethod(SetCartShippingMethod setShippingMethod) {
    this.setShippingMethod = setShippingMethod;
  }

  public SetCartShippingMethodTaxAmount getSetShippingMethodTaxAmount() {
    return setShippingMethodTaxAmount;
  }

  public void setSetShippingMethodTaxAmount(
      SetCartShippingMethodTaxAmount setShippingMethodTaxAmount) {
    this.setShippingMethodTaxAmount = setShippingMethodTaxAmount;
  }

  public SetCartShippingMethodTaxRate getSetShippingMethodTaxRate() {
    return setShippingMethodTaxRate;
  }

  public void setSetShippingMethodTaxRate(SetCartShippingMethodTaxRate setShippingMethodTaxRate) {
    this.setShippingMethodTaxRate = setShippingMethodTaxRate;
  }

  public SetCartShippingRateInput getSetShippingRateInput() {
    return setShippingRateInput;
  }

  public void setSetShippingRateInput(SetCartShippingRateInput setShippingRateInput) {
    this.setShippingRateInput = setShippingRateInput;
  }

  public UpdateCartItemShippingAddress getUpdateItemShippingAddress() {
    return updateItemShippingAddress;
  }

  public void setUpdateItemShippingAddress(
      UpdateCartItemShippingAddress updateItemShippingAddress) {
    this.updateItemShippingAddress = updateItemShippingAddress;
  }

  public FreezeCart getFreezeCart() {
    return freezeCart;
  }

  public void setFreezeCart(FreezeCart freezeCart) {
    this.freezeCart = freezeCart;
  }

  public UnfreezeCart getUnfreezeCart() {
    return unfreezeCart;
  }

  public void setUnfreezeCart(UnfreezeCart unfreezeCart) {
    this.unfreezeCart = unfreezeCart;
  }

  public ChangeCartLineItemQuantity getChangeLineItemQuantity() {
    return changeLineItemQuantity;
  }

  public void setChangeLineItemQuantity(ChangeCartLineItemQuantity changeLineItemQuantity) {
    this.changeLineItemQuantity = changeLineItemQuantity;
  }

  @Override
  public String toString() {
    return "CartUpdateAction{addCustomLineItem='" + addCustomLineItem + "', addCustomShippingMethod='" + addCustomShippingMethod + "', addDiscountCode='" + addDiscountCode + "', addItemShippingAddress='" + addItemShippingAddress + "', addLineItem='" + addLineItem + "', addPayment='" + addPayment + "', addShippingMethod='" + addShippingMethod + "', addShoppingList='" + addShoppingList + "', applyDeltaToCustomLineItemShippingDetailsTargets='" + applyDeltaToCustomLineItemShippingDetailsTargets + "', applyDeltaToLineItemShippingDetailsTargets='" + applyDeltaToLineItemShippingDetailsTargets + "', changeCustomLineItemMoney='" + changeCustomLineItemMoney + "', changeCustomLineItemPriceMode='" + changeCustomLineItemPriceMode + "', changeCustomLineItemQuantity='" + changeCustomLineItemQuantity + "', changeLineItemsOrder='" + changeLineItemsOrder + "', changeTaxCalculationMode='" + changeTaxCalculationMode + "', changeTaxMode='" + changeTaxMode + "', changeTaxRoundingMode='" + changeTaxRoundingMode + "', recalculate='" + recalculate + "', removeCustomLineItem='" + removeCustomLineItem + "', removeDiscountCode='" + removeDiscountCode + "', removeItemShippingAddress='" + removeItemShippingAddress + "', removeLineItem='" + removeLineItem + "', removePayment='" + removePayment + "', removeShippingMethod='" + removeShippingMethod + "', setAnonymousId='" + setAnonymousId + "', setBillingAddress='" + setBillingAddress + "', setBillingAddressCustomField='" + setBillingAddressCustomField + "', setBillingAddressCustomType='" + setBillingAddressCustomType + "', setBusinessUnit='" + setBusinessUnit + "', setKey='" + setKey + "', setCartTotalTax='" + setCartTotalTax + "', setCountry='" + setCountry + "', setCustomField='" + setCustomField + "', setCustomLineItemCustomField='" + setCustomLineItemCustomField + "', setCustomLineItemCustomType='" + setCustomLineItemCustomType + "', setCustomLineItemShippingDetails='" + setCustomLineItemShippingDetails + "', setCustomLineItemTaxAmount='" + setCustomLineItemTaxAmount + "', setCustomLineItemTaxRate='" + setCustomLineItemTaxRate + "', setCustomShippingMethod='" + setCustomShippingMethod + "', setCustomType='" + setCustomType + "', setCustomerEmail='" + setCustomerEmail + "', setCustomerGroup='" + setCustomerGroup + "', setCustomerId='" + setCustomerId + "', setDeleteDaysAfterLastModification='" + setDeleteDaysAfterLastModification + "', setDirectDiscounts='" + setDirectDiscounts + "', setItemShippingAddressCustomField='" + setItemShippingAddressCustomField + "', setItemShippingAddressCustomType='" + setItemShippingAddressCustomType + "', setLineItemCustomField='" + setLineItemCustomField + "', setLineItemCustomType='" + setLineItemCustomType + "', setLineItemDistributionChannel='" + setLineItemDistributionChannel + "', setLineItemInventoryMode='" + setLineItemInventoryMode + "', setLineItemPrice='" + setLineItemPrice + "', setLineItemShippingDetails='" + setLineItemShippingDetails + "', setLineItemSupplyChannel='" + setLineItemSupplyChannel + "', setLineItemTaxAmount='" + setLineItemTaxAmount + "', setLineItemTaxRate='" + setLineItemTaxRate + "', setLineItemTotalPrice='" + setLineItemTotalPrice + "', setLocale='" + setLocale + "', setShippingAddress='" + setShippingAddress + "', setShippingAddressCustomField='" + setShippingAddressCustomField + "', setShippingAddressCustomType='" + setShippingAddressCustomType + "', setShippingCustomField='" + setShippingCustomField + "', setShippingCustomType='" + setShippingCustomType + "', setShippingMethod='" + setShippingMethod + "', setShippingMethodTaxAmount='" + setShippingMethodTaxAmount + "', setShippingMethodTaxRate='" + setShippingMethodTaxRate + "', setShippingRateInput='" + setShippingRateInput + "', updateItemShippingAddress='" + updateItemShippingAddress + "', freezeCart='" + freezeCart + "', unfreezeCart='" + unfreezeCart + "', changeLineItemQuantity='" + changeLineItemQuantity + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartUpdateAction that = (CartUpdateAction) o;
    return Objects.equals(addCustomLineItem, that.addCustomLineItem) &&
        Objects.equals(addCustomShippingMethod, that.addCustomShippingMethod) &&
        Objects.equals(addDiscountCode, that.addDiscountCode) &&
        Objects.equals(addItemShippingAddress, that.addItemShippingAddress) &&
        Objects.equals(addLineItem, that.addLineItem) &&
        Objects.equals(addPayment, that.addPayment) &&
        Objects.equals(addShippingMethod, that.addShippingMethod) &&
        Objects.equals(addShoppingList, that.addShoppingList) &&
        Objects.equals(applyDeltaToCustomLineItemShippingDetailsTargets, that.applyDeltaToCustomLineItemShippingDetailsTargets) &&
        Objects.equals(applyDeltaToLineItemShippingDetailsTargets, that.applyDeltaToLineItemShippingDetailsTargets) &&
        Objects.equals(changeCustomLineItemMoney, that.changeCustomLineItemMoney) &&
        Objects.equals(changeCustomLineItemPriceMode, that.changeCustomLineItemPriceMode) &&
        Objects.equals(changeCustomLineItemQuantity, that.changeCustomLineItemQuantity) &&
        Objects.equals(changeLineItemsOrder, that.changeLineItemsOrder) &&
        Objects.equals(changeTaxCalculationMode, that.changeTaxCalculationMode) &&
        Objects.equals(changeTaxMode, that.changeTaxMode) &&
        Objects.equals(changeTaxRoundingMode, that.changeTaxRoundingMode) &&
        Objects.equals(recalculate, that.recalculate) &&
        Objects.equals(removeCustomLineItem, that.removeCustomLineItem) &&
        Objects.equals(removeDiscountCode, that.removeDiscountCode) &&
        Objects.equals(removeItemShippingAddress, that.removeItemShippingAddress) &&
        Objects.equals(removeLineItem, that.removeLineItem) &&
        Objects.equals(removePayment, that.removePayment) &&
        Objects.equals(removeShippingMethod, that.removeShippingMethod) &&
        Objects.equals(setAnonymousId, that.setAnonymousId) &&
        Objects.equals(setBillingAddress, that.setBillingAddress) &&
        Objects.equals(setBillingAddressCustomField, that.setBillingAddressCustomField) &&
        Objects.equals(setBillingAddressCustomType, that.setBillingAddressCustomType) &&
        Objects.equals(setBusinessUnit, that.setBusinessUnit) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setCartTotalTax, that.setCartTotalTax) &&
        Objects.equals(setCountry, that.setCountry) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomLineItemCustomField, that.setCustomLineItemCustomField) &&
        Objects.equals(setCustomLineItemCustomType, that.setCustomLineItemCustomType) &&
        Objects.equals(setCustomLineItemShippingDetails, that.setCustomLineItemShippingDetails) &&
        Objects.equals(setCustomLineItemTaxAmount, that.setCustomLineItemTaxAmount) &&
        Objects.equals(setCustomLineItemTaxRate, that.setCustomLineItemTaxRate) &&
        Objects.equals(setCustomShippingMethod, that.setCustomShippingMethod) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setCustomerEmail, that.setCustomerEmail) &&
        Objects.equals(setCustomerGroup, that.setCustomerGroup) &&
        Objects.equals(setCustomerId, that.setCustomerId) &&
        Objects.equals(setDeleteDaysAfterLastModification, that.setDeleteDaysAfterLastModification) &&
        Objects.equals(setDirectDiscounts, that.setDirectDiscounts) &&
        Objects.equals(setItemShippingAddressCustomField, that.setItemShippingAddressCustomField) &&
        Objects.equals(setItemShippingAddressCustomType, that.setItemShippingAddressCustomType) &&
        Objects.equals(setLineItemCustomField, that.setLineItemCustomField) &&
        Objects.equals(setLineItemCustomType, that.setLineItemCustomType) &&
        Objects.equals(setLineItemDistributionChannel, that.setLineItemDistributionChannel) &&
        Objects.equals(setLineItemInventoryMode, that.setLineItemInventoryMode) &&
        Objects.equals(setLineItemPrice, that.setLineItemPrice) &&
        Objects.equals(setLineItemShippingDetails, that.setLineItemShippingDetails) &&
        Objects.equals(setLineItemSupplyChannel, that.setLineItemSupplyChannel) &&
        Objects.equals(setLineItemTaxAmount, that.setLineItemTaxAmount) &&
        Objects.equals(setLineItemTaxRate, that.setLineItemTaxRate) &&
        Objects.equals(setLineItemTotalPrice, that.setLineItemTotalPrice) &&
        Objects.equals(setLocale, that.setLocale) &&
        Objects.equals(setShippingAddress, that.setShippingAddress) &&
        Objects.equals(setShippingAddressCustomField, that.setShippingAddressCustomField) &&
        Objects.equals(setShippingAddressCustomType, that.setShippingAddressCustomType) &&
        Objects.equals(setShippingCustomField, that.setShippingCustomField) &&
        Objects.equals(setShippingCustomType, that.setShippingCustomType) &&
        Objects.equals(setShippingMethod, that.setShippingMethod) &&
        Objects.equals(setShippingMethodTaxAmount, that.setShippingMethodTaxAmount) &&
        Objects.equals(setShippingMethodTaxRate, that.setShippingMethodTaxRate) &&
        Objects.equals(setShippingRateInput, that.setShippingRateInput) &&
        Objects.equals(updateItemShippingAddress, that.updateItemShippingAddress) &&
        Objects.equals(freezeCart, that.freezeCart) &&
        Objects.equals(unfreezeCart, that.unfreezeCart) &&
        Objects.equals(changeLineItemQuantity, that.changeLineItemQuantity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addCustomLineItem, addCustomShippingMethod, addDiscountCode, addItemShippingAddress, addLineItem, addPayment, addShippingMethod, addShoppingList, applyDeltaToCustomLineItemShippingDetailsTargets, applyDeltaToLineItemShippingDetailsTargets, changeCustomLineItemMoney, changeCustomLineItemPriceMode, changeCustomLineItemQuantity, changeLineItemsOrder, changeTaxCalculationMode, changeTaxMode, changeTaxRoundingMode, recalculate, removeCustomLineItem, removeDiscountCode, removeItemShippingAddress, removeLineItem, removePayment, removeShippingMethod, setAnonymousId, setBillingAddress, setBillingAddressCustomField, setBillingAddressCustomType, setBusinessUnit, setKey, setCartTotalTax, setCountry, setCustomField, setCustomLineItemCustomField, setCustomLineItemCustomType, setCustomLineItemShippingDetails, setCustomLineItemTaxAmount, setCustomLineItemTaxRate, setCustomShippingMethod, setCustomType, setCustomerEmail, setCustomerGroup, setCustomerId, setDeleteDaysAfterLastModification, setDirectDiscounts, setItemShippingAddressCustomField, setItemShippingAddressCustomType, setLineItemCustomField, setLineItemCustomType, setLineItemDistributionChannel, setLineItemInventoryMode, setLineItemPrice, setLineItemShippingDetails, setLineItemSupplyChannel, setLineItemTaxAmount, setLineItemTaxRate, setLineItemTotalPrice, setLocale, setShippingAddress, setShippingAddressCustomField, setShippingAddressCustomType, setShippingCustomField, setShippingCustomType, setShippingMethod, setShippingMethodTaxAmount, setShippingMethodTaxRate, setShippingRateInput, updateItemShippingAddress, freezeCart, unfreezeCart, changeLineItemQuantity);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddCartCustomLineItem addCustomLineItem;

    private AddCartCustomShippingMethod addCustomShippingMethod;

    private AddCartDiscountCode addDiscountCode;

    private AddCartItemShippingAddress addItemShippingAddress;

    private AddCartLineItem addLineItem;

    private AddCartPayment addPayment;

    private AddCartShippingMethod addShippingMethod;

    private AddCartShoppingList addShoppingList;

    private ApplyCartDeltaToCustomLineItemShippingDetailsTargets applyDeltaToCustomLineItemShippingDetailsTargets;

    private ApplyCartDeltaToLineItemShippingDetailsTargets applyDeltaToLineItemShippingDetailsTargets;

    private ChangeCartCustomLineItemMoney changeCustomLineItemMoney;

    private ChangeCartCustomLineItemPriceMode changeCustomLineItemPriceMode;

    private ChangeCartCustomLineItemQuantity changeCustomLineItemQuantity;

    private ChangeCartLineItemsOrder changeLineItemsOrder;

    private ChangeCartTaxCalculationMode changeTaxCalculationMode;

    private ChangeCartTaxMode changeTaxMode;

    private ChangeCartTaxRoundingMode changeTaxRoundingMode;

    private RecalculateCart recalculate;

    private RemoveCartCustomLineItem removeCustomLineItem;

    private RemoveCartDiscountCode removeDiscountCode;

    private RemoveCartItemShippingAddress removeItemShippingAddress;

    private RemoveCartLineItem removeLineItem;

    private RemoveCartPayment removePayment;

    private RemoveCartShippingMethod removeShippingMethod;

    private SetCartAnonymousId setAnonymousId;

    private SetCartBillingAddress setBillingAddress;

    private SetCartBillingAddressCustomField setBillingAddressCustomField;

    private SetCartBillingAddressCustomType setBillingAddressCustomType;

    private SetCartBusinessUnit setBusinessUnit;

    private SetCartKey setKey;

    private SetCartTotalTax setCartTotalTax;

    private SetCartCountry setCountry;

    private SetCartCustomField setCustomField;

    private SetCartCustomLineItemCustomField setCustomLineItemCustomField;

    private SetCartCustomLineItemCustomType setCustomLineItemCustomType;

    private SetCartCustomLineItemShippingDetails setCustomLineItemShippingDetails;

    private SetCartCustomLineItemTaxAmount setCustomLineItemTaxAmount;

    private SetCartCustomLineItemTaxRate setCustomLineItemTaxRate;

    private SetCartCustomShippingMethod setCustomShippingMethod;

    private SetCartCustomType setCustomType;

    private SetCartCustomerEmail setCustomerEmail;

    private SetCartCustomerGroup setCustomerGroup;

    private SetCartCustomerId setCustomerId;

    private SetCartDeleteDaysAfterLastModification setDeleteDaysAfterLastModification;

    private SetCartDirectDiscounts setDirectDiscounts;

    private SetCartItemShippingAddressCustomField setItemShippingAddressCustomField;

    private SetCartItemShippingAddressCustomType setItemShippingAddressCustomType;

    private SetCartLineItemCustomField setLineItemCustomField;

    private SetCartLineItemCustomType setLineItemCustomType;

    private SetCartLineItemDistributionChannel setLineItemDistributionChannel;

    private SetCartLineItemInventoryMode setLineItemInventoryMode;

    private SetCartLineItemPrice setLineItemPrice;

    private SetCartLineItemShippingDetails setLineItemShippingDetails;

    private SetCartLineItemSupplyChannel setLineItemSupplyChannel;

    private SetCartLineItemTaxAmount setLineItemTaxAmount;

    private SetCartLineItemTaxRate setLineItemTaxRate;

    private SetCartLineItemTotalPrice setLineItemTotalPrice;

    private SetCartLocale setLocale;

    private SetCartShippingAddress setShippingAddress;

    private SetCartShippingAddressCustomField setShippingAddressCustomField;

    private SetCartShippingAddressCustomType setShippingAddressCustomType;

    private SetCartShippingCustomField setShippingCustomField;

    private SetCartShippingCustomType setShippingCustomType;

    private SetCartShippingMethod setShippingMethod;

    private SetCartShippingMethodTaxAmount setShippingMethodTaxAmount;

    private SetCartShippingMethodTaxRate setShippingMethodTaxRate;

    private SetCartShippingRateInput setShippingRateInput;

    private UpdateCartItemShippingAddress updateItemShippingAddress;

    private FreezeCart freezeCart;

    private UnfreezeCart unfreezeCart;

    private ChangeCartLineItemQuantity changeLineItemQuantity;

    public CartUpdateAction build() {
      CartUpdateAction result = new CartUpdateAction();
      result.addCustomLineItem = this.addCustomLineItem;
      result.addCustomShippingMethod = this.addCustomShippingMethod;
      result.addDiscountCode = this.addDiscountCode;
      result.addItemShippingAddress = this.addItemShippingAddress;
      result.addLineItem = this.addLineItem;
      result.addPayment = this.addPayment;
      result.addShippingMethod = this.addShippingMethod;
      result.addShoppingList = this.addShoppingList;
      result.applyDeltaToCustomLineItemShippingDetailsTargets = this.applyDeltaToCustomLineItemShippingDetailsTargets;
      result.applyDeltaToLineItemShippingDetailsTargets = this.applyDeltaToLineItemShippingDetailsTargets;
      result.changeCustomLineItemMoney = this.changeCustomLineItemMoney;
      result.changeCustomLineItemPriceMode = this.changeCustomLineItemPriceMode;
      result.changeCustomLineItemQuantity = this.changeCustomLineItemQuantity;
      result.changeLineItemsOrder = this.changeLineItemsOrder;
      result.changeTaxCalculationMode = this.changeTaxCalculationMode;
      result.changeTaxMode = this.changeTaxMode;
      result.changeTaxRoundingMode = this.changeTaxRoundingMode;
      result.recalculate = this.recalculate;
      result.removeCustomLineItem = this.removeCustomLineItem;
      result.removeDiscountCode = this.removeDiscountCode;
      result.removeItemShippingAddress = this.removeItemShippingAddress;
      result.removeLineItem = this.removeLineItem;
      result.removePayment = this.removePayment;
      result.removeShippingMethod = this.removeShippingMethod;
      result.setAnonymousId = this.setAnonymousId;
      result.setBillingAddress = this.setBillingAddress;
      result.setBillingAddressCustomField = this.setBillingAddressCustomField;
      result.setBillingAddressCustomType = this.setBillingAddressCustomType;
      result.setBusinessUnit = this.setBusinessUnit;
      result.setKey = this.setKey;
      result.setCartTotalTax = this.setCartTotalTax;
      result.setCountry = this.setCountry;
      result.setCustomField = this.setCustomField;
      result.setCustomLineItemCustomField = this.setCustomLineItemCustomField;
      result.setCustomLineItemCustomType = this.setCustomLineItemCustomType;
      result.setCustomLineItemShippingDetails = this.setCustomLineItemShippingDetails;
      result.setCustomLineItemTaxAmount = this.setCustomLineItemTaxAmount;
      result.setCustomLineItemTaxRate = this.setCustomLineItemTaxRate;
      result.setCustomShippingMethod = this.setCustomShippingMethod;
      result.setCustomType = this.setCustomType;
      result.setCustomerEmail = this.setCustomerEmail;
      result.setCustomerGroup = this.setCustomerGroup;
      result.setCustomerId = this.setCustomerId;
      result.setDeleteDaysAfterLastModification = this.setDeleteDaysAfterLastModification;
      result.setDirectDiscounts = this.setDirectDiscounts;
      result.setItemShippingAddressCustomField = this.setItemShippingAddressCustomField;
      result.setItemShippingAddressCustomType = this.setItemShippingAddressCustomType;
      result.setLineItemCustomField = this.setLineItemCustomField;
      result.setLineItemCustomType = this.setLineItemCustomType;
      result.setLineItemDistributionChannel = this.setLineItemDistributionChannel;
      result.setLineItemInventoryMode = this.setLineItemInventoryMode;
      result.setLineItemPrice = this.setLineItemPrice;
      result.setLineItemShippingDetails = this.setLineItemShippingDetails;
      result.setLineItemSupplyChannel = this.setLineItemSupplyChannel;
      result.setLineItemTaxAmount = this.setLineItemTaxAmount;
      result.setLineItemTaxRate = this.setLineItemTaxRate;
      result.setLineItemTotalPrice = this.setLineItemTotalPrice;
      result.setLocale = this.setLocale;
      result.setShippingAddress = this.setShippingAddress;
      result.setShippingAddressCustomField = this.setShippingAddressCustomField;
      result.setShippingAddressCustomType = this.setShippingAddressCustomType;
      result.setShippingCustomField = this.setShippingCustomField;
      result.setShippingCustomType = this.setShippingCustomType;
      result.setShippingMethod = this.setShippingMethod;
      result.setShippingMethodTaxAmount = this.setShippingMethodTaxAmount;
      result.setShippingMethodTaxRate = this.setShippingMethodTaxRate;
      result.setShippingRateInput = this.setShippingRateInput;
      result.updateItemShippingAddress = this.updateItemShippingAddress;
      result.freezeCart = this.freezeCart;
      result.unfreezeCart = this.unfreezeCart;
      result.changeLineItemQuantity = this.changeLineItemQuantity;
      return result;
    }

    public Builder addCustomLineItem(AddCartCustomLineItem addCustomLineItem) {
      this.addCustomLineItem = addCustomLineItem;
      return this;
    }

    public Builder addCustomShippingMethod(AddCartCustomShippingMethod addCustomShippingMethod) {
      this.addCustomShippingMethod = addCustomShippingMethod;
      return this;
    }

    public Builder addDiscountCode(AddCartDiscountCode addDiscountCode) {
      this.addDiscountCode = addDiscountCode;
      return this;
    }

    public Builder addItemShippingAddress(AddCartItemShippingAddress addItemShippingAddress) {
      this.addItemShippingAddress = addItemShippingAddress;
      return this;
    }

    public Builder addLineItem(AddCartLineItem addLineItem) {
      this.addLineItem = addLineItem;
      return this;
    }

    public Builder addPayment(AddCartPayment addPayment) {
      this.addPayment = addPayment;
      return this;
    }

    public Builder addShippingMethod(AddCartShippingMethod addShippingMethod) {
      this.addShippingMethod = addShippingMethod;
      return this;
    }

    public Builder addShoppingList(AddCartShoppingList addShoppingList) {
      this.addShoppingList = addShoppingList;
      return this;
    }

    public Builder applyDeltaToCustomLineItemShippingDetailsTargets(
        ApplyCartDeltaToCustomLineItemShippingDetailsTargets applyDeltaToCustomLineItemShippingDetailsTargets) {
      this.applyDeltaToCustomLineItemShippingDetailsTargets = applyDeltaToCustomLineItemShippingDetailsTargets;
      return this;
    }

    public Builder applyDeltaToLineItemShippingDetailsTargets(
        ApplyCartDeltaToLineItemShippingDetailsTargets applyDeltaToLineItemShippingDetailsTargets) {
      this.applyDeltaToLineItemShippingDetailsTargets = applyDeltaToLineItemShippingDetailsTargets;
      return this;
    }

    public Builder changeCustomLineItemMoney(
        ChangeCartCustomLineItemMoney changeCustomLineItemMoney) {
      this.changeCustomLineItemMoney = changeCustomLineItemMoney;
      return this;
    }

    public Builder changeCustomLineItemPriceMode(
        ChangeCartCustomLineItemPriceMode changeCustomLineItemPriceMode) {
      this.changeCustomLineItemPriceMode = changeCustomLineItemPriceMode;
      return this;
    }

    public Builder changeCustomLineItemQuantity(
        ChangeCartCustomLineItemQuantity changeCustomLineItemQuantity) {
      this.changeCustomLineItemQuantity = changeCustomLineItemQuantity;
      return this;
    }

    public Builder changeLineItemsOrder(ChangeCartLineItemsOrder changeLineItemsOrder) {
      this.changeLineItemsOrder = changeLineItemsOrder;
      return this;
    }

    public Builder changeTaxCalculationMode(ChangeCartTaxCalculationMode changeTaxCalculationMode) {
      this.changeTaxCalculationMode = changeTaxCalculationMode;
      return this;
    }

    public Builder changeTaxMode(ChangeCartTaxMode changeTaxMode) {
      this.changeTaxMode = changeTaxMode;
      return this;
    }

    public Builder changeTaxRoundingMode(ChangeCartTaxRoundingMode changeTaxRoundingMode) {
      this.changeTaxRoundingMode = changeTaxRoundingMode;
      return this;
    }

    public Builder recalculate(RecalculateCart recalculate) {
      this.recalculate = recalculate;
      return this;
    }

    public Builder removeCustomLineItem(RemoveCartCustomLineItem removeCustomLineItem) {
      this.removeCustomLineItem = removeCustomLineItem;
      return this;
    }

    public Builder removeDiscountCode(RemoveCartDiscountCode removeDiscountCode) {
      this.removeDiscountCode = removeDiscountCode;
      return this;
    }

    public Builder removeItemShippingAddress(
        RemoveCartItemShippingAddress removeItemShippingAddress) {
      this.removeItemShippingAddress = removeItemShippingAddress;
      return this;
    }

    public Builder removeLineItem(RemoveCartLineItem removeLineItem) {
      this.removeLineItem = removeLineItem;
      return this;
    }

    public Builder removePayment(RemoveCartPayment removePayment) {
      this.removePayment = removePayment;
      return this;
    }

    public Builder removeShippingMethod(RemoveCartShippingMethod removeShippingMethod) {
      this.removeShippingMethod = removeShippingMethod;
      return this;
    }

    public Builder setAnonymousId(SetCartAnonymousId setAnonymousId) {
      this.setAnonymousId = setAnonymousId;
      return this;
    }

    public Builder setBillingAddress(SetCartBillingAddress setBillingAddress) {
      this.setBillingAddress = setBillingAddress;
      return this;
    }

    public Builder setBillingAddressCustomField(
        SetCartBillingAddressCustomField setBillingAddressCustomField) {
      this.setBillingAddressCustomField = setBillingAddressCustomField;
      return this;
    }

    public Builder setBillingAddressCustomType(
        SetCartBillingAddressCustomType setBillingAddressCustomType) {
      this.setBillingAddressCustomType = setBillingAddressCustomType;
      return this;
    }

    public Builder setBusinessUnit(SetCartBusinessUnit setBusinessUnit) {
      this.setBusinessUnit = setBusinessUnit;
      return this;
    }

    public Builder setKey(SetCartKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setCartTotalTax(SetCartTotalTax setCartTotalTax) {
      this.setCartTotalTax = setCartTotalTax;
      return this;
    }

    public Builder setCountry(SetCartCountry setCountry) {
      this.setCountry = setCountry;
      return this;
    }

    public Builder setCustomField(SetCartCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomLineItemCustomField(
        SetCartCustomLineItemCustomField setCustomLineItemCustomField) {
      this.setCustomLineItemCustomField = setCustomLineItemCustomField;
      return this;
    }

    public Builder setCustomLineItemCustomType(
        SetCartCustomLineItemCustomType setCustomLineItemCustomType) {
      this.setCustomLineItemCustomType = setCustomLineItemCustomType;
      return this;
    }

    public Builder setCustomLineItemShippingDetails(
        SetCartCustomLineItemShippingDetails setCustomLineItemShippingDetails) {
      this.setCustomLineItemShippingDetails = setCustomLineItemShippingDetails;
      return this;
    }

    public Builder setCustomLineItemTaxAmount(
        SetCartCustomLineItemTaxAmount setCustomLineItemTaxAmount) {
      this.setCustomLineItemTaxAmount = setCustomLineItemTaxAmount;
      return this;
    }

    public Builder setCustomLineItemTaxRate(SetCartCustomLineItemTaxRate setCustomLineItemTaxRate) {
      this.setCustomLineItemTaxRate = setCustomLineItemTaxRate;
      return this;
    }

    public Builder setCustomShippingMethod(SetCartCustomShippingMethod setCustomShippingMethod) {
      this.setCustomShippingMethod = setCustomShippingMethod;
      return this;
    }

    public Builder setCustomType(SetCartCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setCustomerEmail(SetCartCustomerEmail setCustomerEmail) {
      this.setCustomerEmail = setCustomerEmail;
      return this;
    }

    public Builder setCustomerGroup(SetCartCustomerGroup setCustomerGroup) {
      this.setCustomerGroup = setCustomerGroup;
      return this;
    }

    public Builder setCustomerId(SetCartCustomerId setCustomerId) {
      this.setCustomerId = setCustomerId;
      return this;
    }

    public Builder setDeleteDaysAfterLastModification(
        SetCartDeleteDaysAfterLastModification setDeleteDaysAfterLastModification) {
      this.setDeleteDaysAfterLastModification = setDeleteDaysAfterLastModification;
      return this;
    }

    public Builder setDirectDiscounts(SetCartDirectDiscounts setDirectDiscounts) {
      this.setDirectDiscounts = setDirectDiscounts;
      return this;
    }

    public Builder setItemShippingAddressCustomField(
        SetCartItemShippingAddressCustomField setItemShippingAddressCustomField) {
      this.setItemShippingAddressCustomField = setItemShippingAddressCustomField;
      return this;
    }

    public Builder setItemShippingAddressCustomType(
        SetCartItemShippingAddressCustomType setItemShippingAddressCustomType) {
      this.setItemShippingAddressCustomType = setItemShippingAddressCustomType;
      return this;
    }

    public Builder setLineItemCustomField(SetCartLineItemCustomField setLineItemCustomField) {
      this.setLineItemCustomField = setLineItemCustomField;
      return this;
    }

    public Builder setLineItemCustomType(SetCartLineItemCustomType setLineItemCustomType) {
      this.setLineItemCustomType = setLineItemCustomType;
      return this;
    }

    public Builder setLineItemDistributionChannel(
        SetCartLineItemDistributionChannel setLineItemDistributionChannel) {
      this.setLineItemDistributionChannel = setLineItemDistributionChannel;
      return this;
    }

    public Builder setLineItemInventoryMode(SetCartLineItemInventoryMode setLineItemInventoryMode) {
      this.setLineItemInventoryMode = setLineItemInventoryMode;
      return this;
    }

    public Builder setLineItemPrice(SetCartLineItemPrice setLineItemPrice) {
      this.setLineItemPrice = setLineItemPrice;
      return this;
    }

    public Builder setLineItemShippingDetails(
        SetCartLineItemShippingDetails setLineItemShippingDetails) {
      this.setLineItemShippingDetails = setLineItemShippingDetails;
      return this;
    }

    public Builder setLineItemSupplyChannel(SetCartLineItemSupplyChannel setLineItemSupplyChannel) {
      this.setLineItemSupplyChannel = setLineItemSupplyChannel;
      return this;
    }

    public Builder setLineItemTaxAmount(SetCartLineItemTaxAmount setLineItemTaxAmount) {
      this.setLineItemTaxAmount = setLineItemTaxAmount;
      return this;
    }

    public Builder setLineItemTaxRate(SetCartLineItemTaxRate setLineItemTaxRate) {
      this.setLineItemTaxRate = setLineItemTaxRate;
      return this;
    }

    public Builder setLineItemTotalPrice(SetCartLineItemTotalPrice setLineItemTotalPrice) {
      this.setLineItemTotalPrice = setLineItemTotalPrice;
      return this;
    }

    public Builder setLocale(SetCartLocale setLocale) {
      this.setLocale = setLocale;
      return this;
    }

    public Builder setShippingAddress(SetCartShippingAddress setShippingAddress) {
      this.setShippingAddress = setShippingAddress;
      return this;
    }

    public Builder setShippingAddressCustomField(
        SetCartShippingAddressCustomField setShippingAddressCustomField) {
      this.setShippingAddressCustomField = setShippingAddressCustomField;
      return this;
    }

    public Builder setShippingAddressCustomType(
        SetCartShippingAddressCustomType setShippingAddressCustomType) {
      this.setShippingAddressCustomType = setShippingAddressCustomType;
      return this;
    }

    public Builder setShippingCustomField(SetCartShippingCustomField setShippingCustomField) {
      this.setShippingCustomField = setShippingCustomField;
      return this;
    }

    public Builder setShippingCustomType(SetCartShippingCustomType setShippingCustomType) {
      this.setShippingCustomType = setShippingCustomType;
      return this;
    }

    public Builder setShippingMethod(SetCartShippingMethod setShippingMethod) {
      this.setShippingMethod = setShippingMethod;
      return this;
    }

    public Builder setShippingMethodTaxAmount(
        SetCartShippingMethodTaxAmount setShippingMethodTaxAmount) {
      this.setShippingMethodTaxAmount = setShippingMethodTaxAmount;
      return this;
    }

    public Builder setShippingMethodTaxRate(SetCartShippingMethodTaxRate setShippingMethodTaxRate) {
      this.setShippingMethodTaxRate = setShippingMethodTaxRate;
      return this;
    }

    public Builder setShippingRateInput(SetCartShippingRateInput setShippingRateInput) {
      this.setShippingRateInput = setShippingRateInput;
      return this;
    }

    public Builder updateItemShippingAddress(
        UpdateCartItemShippingAddress updateItemShippingAddress) {
      this.updateItemShippingAddress = updateItemShippingAddress;
      return this;
    }

    public Builder freezeCart(FreezeCart freezeCart) {
      this.freezeCart = freezeCart;
      return this;
    }

    public Builder unfreezeCart(UnfreezeCart unfreezeCart) {
      this.unfreezeCart = unfreezeCart;
      return this;
    }

    public Builder changeLineItemQuantity(ChangeCartLineItemQuantity changeLineItemQuantity) {
      this.changeLineItemQuantity = changeLineItemQuantity;
      return this;
    }
  }
}
