package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CartsConfiguration {
  private Integer deleteDaysAfterLastModification;

  private Boolean allowAddingUnpublishedProducts;

  private Boolean countryTaxRateFallbackEnabled;

  public CartsConfiguration() {
  }

  public CartsConfiguration(Integer deleteDaysAfterLastModification,
      Boolean allowAddingUnpublishedProducts, Boolean countryTaxRateFallbackEnabled) {
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
    this.allowAddingUnpublishedProducts = allowAddingUnpublishedProducts;
    this.countryTaxRateFallbackEnabled = countryTaxRateFallbackEnabled;
  }

  public Integer getDeleteDaysAfterLastModification() {
    return deleteDaysAfterLastModification;
  }

  public void setDeleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
  }

  public Boolean getAllowAddingUnpublishedProducts() {
    return allowAddingUnpublishedProducts;
  }

  public void setAllowAddingUnpublishedProducts(Boolean allowAddingUnpublishedProducts) {
    this.allowAddingUnpublishedProducts = allowAddingUnpublishedProducts;
  }

  public Boolean getCountryTaxRateFallbackEnabled() {
    return countryTaxRateFallbackEnabled;
  }

  public void setCountryTaxRateFallbackEnabled(Boolean countryTaxRateFallbackEnabled) {
    this.countryTaxRateFallbackEnabled = countryTaxRateFallbackEnabled;
  }

  @Override
  public String toString() {
    return "CartsConfiguration{deleteDaysAfterLastModification='" + deleteDaysAfterLastModification + "', allowAddingUnpublishedProducts='" + allowAddingUnpublishedProducts + "', countryTaxRateFallbackEnabled='" + countryTaxRateFallbackEnabled + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartsConfiguration that = (CartsConfiguration) o;
    return Objects.equals(deleteDaysAfterLastModification, that.deleteDaysAfterLastModification) &&
        Objects.equals(allowAddingUnpublishedProducts, that.allowAddingUnpublishedProducts) &&
        Objects.equals(countryTaxRateFallbackEnabled, that.countryTaxRateFallbackEnabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deleteDaysAfterLastModification, allowAddingUnpublishedProducts, countryTaxRateFallbackEnabled);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer deleteDaysAfterLastModification;

    private Boolean allowAddingUnpublishedProducts;

    private Boolean countryTaxRateFallbackEnabled;

    public CartsConfiguration build() {
      CartsConfiguration result = new CartsConfiguration();
      result.deleteDaysAfterLastModification = this.deleteDaysAfterLastModification;
      result.allowAddingUnpublishedProducts = this.allowAddingUnpublishedProducts;
      result.countryTaxRateFallbackEnabled = this.countryTaxRateFallbackEnabled;
      return result;
    }

    public Builder deleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
      this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
      return this;
    }

    public Builder allowAddingUnpublishedProducts(Boolean allowAddingUnpublishedProducts) {
      this.allowAddingUnpublishedProducts = allowAddingUnpublishedProducts;
      return this;
    }

    public Builder countryTaxRateFallbackEnabled(Boolean countryTaxRateFallbackEnabled) {
      this.countryTaxRateFallbackEnabled = countryTaxRateFallbackEnabled;
      return this;
    }
  }
}
