package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Category implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String id;

  private String key;

  private Long version;

  private String name;

  private List<LocalizedString> nameAllLocales;

  private String description;

  private List<LocalizedString> descriptionAllLocales;

  private String slug;

  private List<LocalizedString> slugAllLocales;

  private List<Reference> ancestorsRef;

  private List<Category> ancestors;

  private Reference parentRef;

  private Category _parent;

  private String orderHint;

  private String externalId;

  private String metaTitle;

  private List<LocalizedString> metaTitleAllLocales;

  private String metaKeywords;

  private List<LocalizedString> metaKeywordsAllLocales;

  private String metaDescription;

  private List<LocalizedString> metaDescriptionAllLocales;

  /**
   * Number of staged products in the category subtree.
   */
  private Integer stagedProductCount;

  /**
   * Number of direct child categories.
   */
  private Integer childCount;

  /**
   * Direct child categories.
   */
  private List<Category> children;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private List<Asset> assets;

  private CustomFieldsType custom;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public Category() {
  }

  public Category(String id, String key, Long version, String name,
      List<LocalizedString> nameAllLocales, String description,
      List<LocalizedString> descriptionAllLocales, String slug,
      List<LocalizedString> slugAllLocales, List<Reference> ancestorsRef, List<Category> ancestors,
      Reference parentRef, Category _parent, String orderHint, String externalId, String metaTitle,
      List<LocalizedString> metaTitleAllLocales, String metaKeywords,
      List<LocalizedString> metaKeywordsAllLocales, String metaDescription,
      List<LocalizedString> metaDescriptionAllLocales, Integer stagedProductCount,
      Integer childCount, List<Category> children, OffsetDateTime createdAt,
      OffsetDateTime lastModifiedAt, List<Asset> assets, CustomFieldsType custom,
      Initiator createdBy, Initiator lastModifiedBy) {
    this.id = id;
    this.key = key;
    this.version = version;
    this.name = name;
    this.nameAllLocales = nameAllLocales;
    this.description = description;
    this.descriptionAllLocales = descriptionAllLocales;
    this.slug = slug;
    this.slugAllLocales = slugAllLocales;
    this.ancestorsRef = ancestorsRef;
    this.ancestors = ancestors;
    this.parentRef = parentRef;
    this._parent = _parent;
    this.orderHint = orderHint;
    this.externalId = externalId;
    this.metaTitle = metaTitle;
    this.metaTitleAllLocales = metaTitleAllLocales;
    this.metaKeywords = metaKeywords;
    this.metaKeywordsAllLocales = metaKeywordsAllLocales;
    this.metaDescription = metaDescription;
    this.metaDescriptionAllLocales = metaDescriptionAllLocales;
    this.stagedProductCount = stagedProductCount;
    this.childCount = childCount;
    this.children = children;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.assets = assets;
    this.custom = custom;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<LocalizedString> getDescriptionAllLocales() {
    return descriptionAllLocales;
  }

  public void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
    this.descriptionAllLocales = descriptionAllLocales;
  }

  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public List<LocalizedString> getSlugAllLocales() {
    return slugAllLocales;
  }

  public void setSlugAllLocales(List<LocalizedString> slugAllLocales) {
    this.slugAllLocales = slugAllLocales;
  }

  public List<Reference> getAncestorsRef() {
    return ancestorsRef;
  }

  public void setAncestorsRef(List<Reference> ancestorsRef) {
    this.ancestorsRef = ancestorsRef;
  }

  public List<Category> getAncestors() {
    return ancestors;
  }

  public void setAncestors(List<Category> ancestors) {
    this.ancestors = ancestors;
  }

  public Reference getParentRef() {
    return parentRef;
  }

  public void setParentRef(Reference parentRef) {
    this.parentRef = parentRef;
  }

  public Category getParent() {
    return _parent;
  }

  public void setParent(Category _parent) {
    this._parent = _parent;
  }

  public String getOrderHint() {
    return orderHint;
  }

  public void setOrderHint(String orderHint) {
    this.orderHint = orderHint;
  }

  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public String getMetaTitle() {
    return metaTitle;
  }

  public void setMetaTitle(String metaTitle) {
    this.metaTitle = metaTitle;
  }

  public List<LocalizedString> getMetaTitleAllLocales() {
    return metaTitleAllLocales;
  }

  public void setMetaTitleAllLocales(List<LocalizedString> metaTitleAllLocales) {
    this.metaTitleAllLocales = metaTitleAllLocales;
  }

  public String getMetaKeywords() {
    return metaKeywords;
  }

  public void setMetaKeywords(String metaKeywords) {
    this.metaKeywords = metaKeywords;
  }

  public List<LocalizedString> getMetaKeywordsAllLocales() {
    return metaKeywordsAllLocales;
  }

  public void setMetaKeywordsAllLocales(List<LocalizedString> metaKeywordsAllLocales) {
    this.metaKeywordsAllLocales = metaKeywordsAllLocales;
  }

  public String getMetaDescription() {
    return metaDescription;
  }

  public void setMetaDescription(String metaDescription) {
    this.metaDescription = metaDescription;
  }

  public List<LocalizedString> getMetaDescriptionAllLocales() {
    return metaDescriptionAllLocales;
  }

  public void setMetaDescriptionAllLocales(List<LocalizedString> metaDescriptionAllLocales) {
    this.metaDescriptionAllLocales = metaDescriptionAllLocales;
  }

  /**
   * Number of staged products in the category subtree.
   */
  public Integer getStagedProductCount() {
    return stagedProductCount;
  }

  public void setStagedProductCount(Integer stagedProductCount) {
    this.stagedProductCount = stagedProductCount;
  }

  /**
   * Number of direct child categories.
   */
  public Integer getChildCount() {
    return childCount;
  }

  public void setChildCount(Integer childCount) {
    this.childCount = childCount;
  }

  /**
   * Direct child categories.
   */
  public List<Category> getChildren() {
    return children;
  }

  public void setChildren(List<Category> children) {
    this.children = children;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public List<Asset> getAssets() {
    return assets;
  }

  public void setAssets(List<Asset> assets) {
    this.assets = assets;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "Category{id='" + id + "', key='" + key + "', version='" + version + "', name='" + name + "', nameAllLocales='" + nameAllLocales + "', description='" + description + "', descriptionAllLocales='" + descriptionAllLocales + "', slug='" + slug + "', slugAllLocales='" + slugAllLocales + "', ancestorsRef='" + ancestorsRef + "', ancestors='" + ancestors + "', parentRef='" + parentRef + "', parent='" + _parent + "', orderHint='" + orderHint + "', externalId='" + externalId + "', metaTitle='" + metaTitle + "', metaTitleAllLocales='" + metaTitleAllLocales + "', metaKeywords='" + metaKeywords + "', metaKeywordsAllLocales='" + metaKeywordsAllLocales + "', metaDescription='" + metaDescription + "', metaDescriptionAllLocales='" + metaDescriptionAllLocales + "', stagedProductCount='" + stagedProductCount + "', childCount='" + childCount + "', children='" + children + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', assets='" + assets + "', custom='" + custom + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Category that = (Category) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(key, that.key) &&
        Objects.equals(version, that.version) &&
        Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(description, that.description) &&
        Objects.equals(descriptionAllLocales, that.descriptionAllLocales) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(slugAllLocales, that.slugAllLocales) &&
        Objects.equals(ancestorsRef, that.ancestorsRef) &&
        Objects.equals(ancestors, that.ancestors) &&
        Objects.equals(parentRef, that.parentRef) &&
        Objects.equals(_parent, that._parent) &&
        Objects.equals(orderHint, that.orderHint) &&
        Objects.equals(externalId, that.externalId) &&
        Objects.equals(metaTitle, that.metaTitle) &&
        Objects.equals(metaTitleAllLocales, that.metaTitleAllLocales) &&
        Objects.equals(metaKeywords, that.metaKeywords) &&
        Objects.equals(metaKeywordsAllLocales, that.metaKeywordsAllLocales) &&
        Objects.equals(metaDescription, that.metaDescription) &&
        Objects.equals(metaDescriptionAllLocales, that.metaDescriptionAllLocales) &&
        Objects.equals(stagedProductCount, that.stagedProductCount) &&
        Objects.equals(childCount, that.childCount) &&
        Objects.equals(children, that.children) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(assets, that.assets) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, version, name, nameAllLocales, description, descriptionAllLocales, slug, slugAllLocales, ancestorsRef, ancestors, parentRef, _parent, orderHint, externalId, metaTitle, metaTitleAllLocales, metaKeywords, metaKeywordsAllLocales, metaDescription, metaDescriptionAllLocales, stagedProductCount, childCount, children, createdAt, lastModifiedAt, assets, custom, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private String key;

    private Long version;

    private String name;

    private List<LocalizedString> nameAllLocales;

    private String description;

    private List<LocalizedString> descriptionAllLocales;

    private String slug;

    private List<LocalizedString> slugAllLocales;

    private List<Reference> ancestorsRef;

    private List<Category> ancestors;

    private Reference parentRef;

    private Category _parent;

    private String orderHint;

    private String externalId;

    private String metaTitle;

    private List<LocalizedString> metaTitleAllLocales;

    private String metaKeywords;

    private List<LocalizedString> metaKeywordsAllLocales;

    private String metaDescription;

    private List<LocalizedString> metaDescriptionAllLocales;

    /**
     * Number of staged products in the category subtree.
     */
    private Integer stagedProductCount;

    /**
     * Number of direct child categories.
     */
    private Integer childCount;

    /**
     * Direct child categories.
     */
    private List<Category> children;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private List<Asset> assets;

    private CustomFieldsType custom;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public Category build() {
      Category result = new Category();
      result.id = this.id;
      result.key = this.key;
      result.version = this.version;
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      result.description = this.description;
      result.descriptionAllLocales = this.descriptionAllLocales;
      result.slug = this.slug;
      result.slugAllLocales = this.slugAllLocales;
      result.ancestorsRef = this.ancestorsRef;
      result.ancestors = this.ancestors;
      result.parentRef = this.parentRef;
      result._parent = this._parent;
      result.orderHint = this.orderHint;
      result.externalId = this.externalId;
      result.metaTitle = this.metaTitle;
      result.metaTitleAllLocales = this.metaTitleAllLocales;
      result.metaKeywords = this.metaKeywords;
      result.metaKeywordsAllLocales = this.metaKeywordsAllLocales;
      result.metaDescription = this.metaDescription;
      result.metaDescriptionAllLocales = this.metaDescriptionAllLocales;
      result.stagedProductCount = this.stagedProductCount;
      result.childCount = this.childCount;
      result.children = this.children;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.assets = this.assets;
      result.custom = this.custom;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder descriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
      this.descriptionAllLocales = descriptionAllLocales;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = slug;
      return this;
    }

    public Builder slugAllLocales(List<LocalizedString> slugAllLocales) {
      this.slugAllLocales = slugAllLocales;
      return this;
    }

    public Builder ancestorsRef(List<Reference> ancestorsRef) {
      this.ancestorsRef = ancestorsRef;
      return this;
    }

    public Builder ancestors(List<Category> ancestors) {
      this.ancestors = ancestors;
      return this;
    }

    public Builder parentRef(Reference parentRef) {
      this.parentRef = parentRef;
      return this;
    }

    public Builder _parent(Category _parent) {
      this._parent = _parent;
      return this;
    }

    public Builder orderHint(String orderHint) {
      this.orderHint = orderHint;
      return this;
    }

    public Builder externalId(String externalId) {
      this.externalId = externalId;
      return this;
    }

    public Builder metaTitle(String metaTitle) {
      this.metaTitle = metaTitle;
      return this;
    }

    public Builder metaTitleAllLocales(List<LocalizedString> metaTitleAllLocales) {
      this.metaTitleAllLocales = metaTitleAllLocales;
      return this;
    }

    public Builder metaKeywords(String metaKeywords) {
      this.metaKeywords = metaKeywords;
      return this;
    }

    public Builder metaKeywordsAllLocales(List<LocalizedString> metaKeywordsAllLocales) {
      this.metaKeywordsAllLocales = metaKeywordsAllLocales;
      return this;
    }

    public Builder metaDescription(String metaDescription) {
      this.metaDescription = metaDescription;
      return this;
    }

    public Builder metaDescriptionAllLocales(List<LocalizedString> metaDescriptionAllLocales) {
      this.metaDescriptionAllLocales = metaDescriptionAllLocales;
      return this;
    }

    /**
     * Number of staged products in the category subtree.
     */
    public Builder stagedProductCount(Integer stagedProductCount) {
      this.stagedProductCount = stagedProductCount;
      return this;
    }

    /**
     * Number of direct child categories.
     */
    public Builder childCount(Integer childCount) {
      this.childCount = childCount;
      return this;
    }

    /**
     * Direct child categories.
     */
    public Builder children(List<Category> children) {
      this.children = children;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder assets(List<Asset> assets) {
      this.assets = assets;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
