package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CategoryCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private Category category;

  private String type;

  public CategoryCreated() {
  }

  public CategoryCreated(Category category, String type) {
    this.category = category;
    this.type = type;
  }

  public Category getCategory() {
    return category;
  }

  public void setCategory(Category category) {
    this.category = category;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CategoryCreated{category='" + category + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CategoryCreated that = (CategoryCreated) o;
    return Objects.equals(category, that.category) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(category, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Category category;

    private String type;

    public CategoryCreated build() {
      CategoryCreated result = new CategoryCreated();
      result.category = this.category;
      result.type = this.type;
      return result;
    }

    public Builder category(Category category) {
      this.category = category;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
