package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CategoryDraft {
  private String key;

  private List<LocalizedStringItemInputType> name;

  private List<LocalizedStringItemInputType> description;

  private CustomFieldsDraft custom;

  private List<LocalizedStringItemInputType> slug;

  private String externalId;

  private List<LocalizedStringItemInputType> metaTitle;

  private List<LocalizedStringItemInputType> metaDescription;

  private List<LocalizedStringItemInputType> metaKeywords;

  private String orderHint;

  private ResourceIdentifierInput _parent;

  private List<AssetDraftInput> assets = Collections.emptyList();

  public CategoryDraft() {
  }

  public CategoryDraft(String key, List<LocalizedStringItemInputType> name,
      List<LocalizedStringItemInputType> description, CustomFieldsDraft custom,
      List<LocalizedStringItemInputType> slug, String externalId,
      List<LocalizedStringItemInputType> metaTitle,
      List<LocalizedStringItemInputType> metaDescription,
      List<LocalizedStringItemInputType> metaKeywords, String orderHint,
      ResourceIdentifierInput _parent, List<AssetDraftInput> assets) {
    this.key = key;
    this.name = name;
    this.description = description;
    this.custom = custom;
    this.slug = slug;
    this.externalId = externalId;
    this.metaTitle = metaTitle;
    this.metaDescription = metaDescription;
    this.metaKeywords = metaKeywords;
    this.orderHint = orderHint;
    this._parent = _parent;
    this.assets = assets;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public List<LocalizedStringItemInputType> getSlug() {
    return slug;
  }

  public void setSlug(List<LocalizedStringItemInputType> slug) {
    this.slug = slug;
  }

  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public List<LocalizedStringItemInputType> getMetaTitle() {
    return metaTitle;
  }

  public void setMetaTitle(List<LocalizedStringItemInputType> metaTitle) {
    this.metaTitle = metaTitle;
  }

  public List<LocalizedStringItemInputType> getMetaDescription() {
    return metaDescription;
  }

  public void setMetaDescription(List<LocalizedStringItemInputType> metaDescription) {
    this.metaDescription = metaDescription;
  }

  public List<LocalizedStringItemInputType> getMetaKeywords() {
    return metaKeywords;
  }

  public void setMetaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
    this.metaKeywords = metaKeywords;
  }

  public String getOrderHint() {
    return orderHint;
  }

  public void setOrderHint(String orderHint) {
    this.orderHint = orderHint;
  }

  public ResourceIdentifierInput getParent() {
    return _parent;
  }

  public void setParent(ResourceIdentifierInput _parent) {
    this._parent = _parent;
  }

  public List<AssetDraftInput> getAssets() {
    return assets;
  }

  public void setAssets(List<AssetDraftInput> assets) {
    this.assets = assets;
  }

  @Override
  public String toString() {
    return "CategoryDraft{key='" + key + "', name='" + name + "', description='" + description + "', custom='" + custom + "', slug='" + slug + "', externalId='" + externalId + "', metaTitle='" + metaTitle + "', metaDescription='" + metaDescription + "', metaKeywords='" + metaKeywords + "', orderHint='" + orderHint + "', parent='" + _parent + "', assets='" + assets + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CategoryDraft that = (CategoryDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(externalId, that.externalId) &&
        Objects.equals(metaTitle, that.metaTitle) &&
        Objects.equals(metaDescription, that.metaDescription) &&
        Objects.equals(metaKeywords, that.metaKeywords) &&
        Objects.equals(orderHint, that.orderHint) &&
        Objects.equals(_parent, that._parent) &&
        Objects.equals(assets, that.assets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, description, custom, slug, externalId, metaTitle, metaDescription, metaKeywords, orderHint, _parent, assets);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private List<LocalizedStringItemInputType> name;

    private List<LocalizedStringItemInputType> description;

    private CustomFieldsDraft custom;

    private List<LocalizedStringItemInputType> slug;

    private String externalId;

    private List<LocalizedStringItemInputType> metaTitle;

    private List<LocalizedStringItemInputType> metaDescription;

    private List<LocalizedStringItemInputType> metaKeywords;

    private String orderHint;

    private ResourceIdentifierInput _parent;

    private List<AssetDraftInput> assets = Collections.emptyList();

    public CategoryDraft build() {
      CategoryDraft result = new CategoryDraft();
      result.key = this.key;
      result.name = this.name;
      result.description = this.description;
      result.custom = this.custom;
      result.slug = this.slug;
      result.externalId = this.externalId;
      result.metaTitle = this.metaTitle;
      result.metaDescription = this.metaDescription;
      result.metaKeywords = this.metaKeywords;
      result.orderHint = this.orderHint;
      result._parent = this._parent;
      result.assets = this.assets;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder slug(List<LocalizedStringItemInputType> slug) {
      this.slug = slug;
      return this;
    }

    public Builder externalId(String externalId) {
      this.externalId = externalId;
      return this;
    }

    public Builder metaTitle(List<LocalizedStringItemInputType> metaTitle) {
      this.metaTitle = metaTitle;
      return this;
    }

    public Builder metaDescription(List<LocalizedStringItemInputType> metaDescription) {
      this.metaDescription = metaDescription;
      return this;
    }

    public Builder metaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
      this.metaKeywords = metaKeywords;
      return this;
    }

    public Builder orderHint(String orderHint) {
      this.orderHint = orderHint;
      return this;
    }

    public Builder _parent(ResourceIdentifierInput _parent) {
      this._parent = _parent;
      return this;
    }

    public Builder assets(List<AssetDraftInput> assets) {
      this.assets = assets;
      return this;
    }
  }
}
