package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CategoryLimitsProjection {
  private Limit maxCategories;

  public CategoryLimitsProjection() {
  }

  public CategoryLimitsProjection(Limit maxCategories) {
    this.maxCategories = maxCategories;
  }

  public Limit getMaxCategories() {
    return maxCategories;
  }

  public void setMaxCategories(Limit maxCategories) {
    this.maxCategories = maxCategories;
  }

  @Override
  public String toString() {
    return "CategoryLimitsProjection{maxCategories='" + maxCategories + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CategoryLimitsProjection that = (CategoryLimitsProjection) o;
    return Objects.equals(maxCategories, that.maxCategories);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maxCategories);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Limit maxCategories;

    public CategoryLimitsProjection build() {
      CategoryLimitsProjection result = new CategoryLimitsProjection();
      result.maxCategories = this.maxCategories;
      return result;
    }

    public Builder maxCategories(Limit maxCategories) {
      this.maxCategories = maxCategories;
      return this;
    }
  }
}
