package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeBusinessUnitApprovalRuleMode {
  private BusinessUnitApprovalRuleMode approvalRuleMode;

  public ChangeBusinessUnitApprovalRuleMode() {
  }

  public ChangeBusinessUnitApprovalRuleMode(BusinessUnitApprovalRuleMode approvalRuleMode) {
    this.approvalRuleMode = approvalRuleMode;
  }

  public BusinessUnitApprovalRuleMode getApprovalRuleMode() {
    return approvalRuleMode;
  }

  public void setApprovalRuleMode(BusinessUnitApprovalRuleMode approvalRuleMode) {
    this.approvalRuleMode = approvalRuleMode;
  }

  @Override
  public String toString() {
    return "ChangeBusinessUnitApprovalRuleMode{approvalRuleMode='" + approvalRuleMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeBusinessUnitApprovalRuleMode that = (ChangeBusinessUnitApprovalRuleMode) o;
    return Objects.equals(approvalRuleMode, that.approvalRuleMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(approvalRuleMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BusinessUnitApprovalRuleMode approvalRuleMode;

    public ChangeBusinessUnitApprovalRuleMode build() {
      ChangeBusinessUnitApprovalRuleMode result = new ChangeBusinessUnitApprovalRuleMode();
      result.approvalRuleMode = this.approvalRuleMode;
      return result;
    }

    public Builder approvalRuleMode(BusinessUnitApprovalRuleMode approvalRuleMode) {
      this.approvalRuleMode = approvalRuleMode;
      return this;
    }
  }
}
