package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCartDiscountSortOrder {
  private String sortOrder;

  public ChangeCartDiscountSortOrder() {
  }

  public ChangeCartDiscountSortOrder(String sortOrder) {
    this.sortOrder = sortOrder;
  }

  public String getSortOrder() {
    return sortOrder;
  }

  public void setSortOrder(String sortOrder) {
    this.sortOrder = sortOrder;
  }

  @Override
  public String toString() {
    return "ChangeCartDiscountSortOrder{sortOrder='" + sortOrder + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCartDiscountSortOrder that = (ChangeCartDiscountSortOrder) o;
    return Objects.equals(sortOrder, that.sortOrder);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sortOrder);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String sortOrder;

    public ChangeCartDiscountSortOrder build() {
      ChangeCartDiscountSortOrder result = new ChangeCartDiscountSortOrder();
      result.sortOrder = this.sortOrder;
      return result;
    }

    public Builder sortOrder(String sortOrder) {
      this.sortOrder = sortOrder;
      return this;
    }
  }
}
