package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCartDiscountTarget {
  private CartDiscountTargetInput target;

  public ChangeCartDiscountTarget() {
  }

  public ChangeCartDiscountTarget(CartDiscountTargetInput target) {
    this.target = target;
  }

  public CartDiscountTargetInput getTarget() {
    return target;
  }

  public void setTarget(CartDiscountTargetInput target) {
    this.target = target;
  }

  @Override
  public String toString() {
    return "ChangeCartDiscountTarget{target='" + target + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCartDiscountTarget that = (ChangeCartDiscountTarget) o;
    return Objects.equals(target, that.target);
  }

  @Override
  public int hashCode() {
    return Objects.hash(target);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CartDiscountTargetInput target;

    public ChangeCartDiscountTarget build() {
      ChangeCartDiscountTarget result = new ChangeCartDiscountTarget();
      result.target = this.target;
      return result;
    }

    public Builder target(CartDiscountTargetInput target) {
      this.target = target;
      return this;
    }
  }
}
