package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCartLineItemQuantity {
  private String lineItemId;

  private String lineItemKey;

  private Long quantity;

  /**
   * Only valid for the general Carts API. Ignored for the My Carts API.
   */
  private BaseMoneyInput externalPrice;

  /**
   * Only valid for the general Carts API. Ignored for the My Carts API.
   */
  private ExternalLineItemTotalPriceDraft externalTotalPrice;

  public ChangeCartLineItemQuantity() {
  }

  public ChangeCartLineItemQuantity(String lineItemId, String lineItemKey, Long quantity,
      BaseMoneyInput externalPrice, ExternalLineItemTotalPriceDraft externalTotalPrice) {
    this.lineItemId = lineItemId;
    this.lineItemKey = lineItemKey;
    this.quantity = quantity;
    this.externalPrice = externalPrice;
    this.externalTotalPrice = externalTotalPrice;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  /**
   * Only valid for the general Carts API. Ignored for the My Carts API.
   */
  public BaseMoneyInput getExternalPrice() {
    return externalPrice;
  }

  public void setExternalPrice(BaseMoneyInput externalPrice) {
    this.externalPrice = externalPrice;
  }

  /**
   * Only valid for the general Carts API. Ignored for the My Carts API.
   */
  public ExternalLineItemTotalPriceDraft getExternalTotalPrice() {
    return externalTotalPrice;
  }

  public void setExternalTotalPrice(ExternalLineItemTotalPriceDraft externalTotalPrice) {
    this.externalTotalPrice = externalTotalPrice;
  }

  @Override
  public String toString() {
    return "ChangeCartLineItemQuantity{lineItemId='" + lineItemId + "', lineItemKey='" + lineItemKey + "', quantity='" + quantity + "', externalPrice='" + externalPrice + "', externalTotalPrice='" + externalTotalPrice + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCartLineItemQuantity that = (ChangeCartLineItemQuantity) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(externalPrice, that.externalPrice) &&
        Objects.equals(externalTotalPrice, that.externalTotalPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, lineItemKey, quantity, externalPrice, externalTotalPrice);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private String lineItemKey;

    private Long quantity;

    /**
     * Only valid for the general Carts API. Ignored for the My Carts API.
     */
    private BaseMoneyInput externalPrice;

    /**
     * Only valid for the general Carts API. Ignored for the My Carts API.
     */
    private ExternalLineItemTotalPriceDraft externalTotalPrice;

    public ChangeCartLineItemQuantity build() {
      ChangeCartLineItemQuantity result = new ChangeCartLineItemQuantity();
      result.lineItemId = this.lineItemId;
      result.lineItemKey = this.lineItemKey;
      result.quantity = this.quantity;
      result.externalPrice = this.externalPrice;
      result.externalTotalPrice = this.externalTotalPrice;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    /**
     * Only valid for the general Carts API. Ignored for the My Carts API.
     */
    public Builder externalPrice(BaseMoneyInput externalPrice) {
      this.externalPrice = externalPrice;
      return this;
    }

    /**
     * Only valid for the general Carts API. Ignored for the My Carts API.
     */
    public Builder externalTotalPrice(ExternalLineItemTotalPriceDraft externalTotalPrice) {
      this.externalTotalPrice = externalTotalPrice;
      return this;
    }
  }
}
