package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCartTaxCalculationMode {
  private TaxCalculationMode taxCalculationMode;

  public ChangeCartTaxCalculationMode() {
  }

  public ChangeCartTaxCalculationMode(TaxCalculationMode taxCalculationMode) {
    this.taxCalculationMode = taxCalculationMode;
  }

  public TaxCalculationMode getTaxCalculationMode() {
    return taxCalculationMode;
  }

  public void setTaxCalculationMode(TaxCalculationMode taxCalculationMode) {
    this.taxCalculationMode = taxCalculationMode;
  }

  @Override
  public String toString() {
    return "ChangeCartTaxCalculationMode{taxCalculationMode='" + taxCalculationMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCartTaxCalculationMode that = (ChangeCartTaxCalculationMode) o;
    return Objects.equals(taxCalculationMode, that.taxCalculationMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxCalculationMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private TaxCalculationMode taxCalculationMode;

    public ChangeCartTaxCalculationMode build() {
      ChangeCartTaxCalculationMode result = new ChangeCartTaxCalculationMode();
      result.taxCalculationMode = this.taxCalculationMode;
      return result;
    }

    public Builder taxCalculationMode(TaxCalculationMode taxCalculationMode) {
      this.taxCalculationMode = taxCalculationMode;
      return this;
    }
  }
}
