package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeCategoryAssetName {
  private List<LocalizedStringItemInputType> name;

  private String assetKey;

  private String assetId;

  public ChangeCategoryAssetName() {
  }

  public ChangeCategoryAssetName(List<LocalizedStringItemInputType> name, String assetKey,
      String assetId) {
    this.name = name;
    this.assetKey = assetKey;
    this.assetId = assetId;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public String getAssetKey() {
    return assetKey;
  }

  public void setAssetKey(String assetKey) {
    this.assetKey = assetKey;
  }

  public String getAssetId() {
    return assetId;
  }

  public void setAssetId(String assetId) {
    this.assetId = assetId;
  }

  @Override
  public String toString() {
    return "ChangeCategoryAssetName{name='" + name + "', assetKey='" + assetKey + "', assetId='" + assetId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCategoryAssetName that = (ChangeCategoryAssetName) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(assetKey, that.assetKey) &&
        Objects.equals(assetId, that.assetId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, assetKey, assetId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> name;

    private String assetKey;

    private String assetId;

    public ChangeCategoryAssetName build() {
      ChangeCategoryAssetName result = new ChangeCategoryAssetName();
      result.name = this.name;
      result.assetKey = this.assetKey;
      result.assetId = this.assetId;
      return result;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder assetKey(String assetKey) {
      this.assetKey = assetKey;
      return this;
    }

    public Builder assetId(String assetId) {
      this.assetId = assetId;
      return this;
    }
  }
}
