package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCategoryParent {
  private ResourceIdentifierInput _parent;

  public ChangeCategoryParent() {
  }

  public ChangeCategoryParent(ResourceIdentifierInput _parent) {
    this._parent = _parent;
  }

  public ResourceIdentifierInput getParent() {
    return _parent;
  }

  public void setParent(ResourceIdentifierInput _parent) {
    this._parent = _parent;
  }

  @Override
  public String toString() {
    return "ChangeCategoryParent{parent='" + _parent + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCategoryParent that = (ChangeCategoryParent) o;
    return Objects.equals(_parent, that._parent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(_parent);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput _parent;

    public ChangeCategoryParent build() {
      ChangeCategoryParent result = new ChangeCategoryParent();
      result._parent = this._parent;
      return result;
    }

    public Builder _parent(ResourceIdentifierInput _parent) {
      this._parent = _parent;
      return this;
    }
  }
}
