package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeDiscountCodeCartDiscounts {
  private List<ResourceIdentifierInput> cartDiscounts;

  public ChangeDiscountCodeCartDiscounts() {
  }

  public ChangeDiscountCodeCartDiscounts(List<ResourceIdentifierInput> cartDiscounts) {
    this.cartDiscounts = cartDiscounts;
  }

  public List<ResourceIdentifierInput> getCartDiscounts() {
    return cartDiscounts;
  }

  public void setCartDiscounts(List<ResourceIdentifierInput> cartDiscounts) {
    this.cartDiscounts = cartDiscounts;
  }

  @Override
  public String toString() {
    return "ChangeDiscountCodeCartDiscounts{cartDiscounts='" + cartDiscounts + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeDiscountCodeCartDiscounts that = (ChangeDiscountCodeCartDiscounts) o;
    return Objects.equals(cartDiscounts, that.cartDiscounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cartDiscounts);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ResourceIdentifierInput> cartDiscounts;

    public ChangeDiscountCodeCartDiscounts build() {
      ChangeDiscountCodeCartDiscounts result = new ChangeDiscountCodeCartDiscounts();
      result.cartDiscounts = this.cartDiscounts;
      return result;
    }

    public Builder cartDiscounts(List<ResourceIdentifierInput> cartDiscounts) {
      this.cartDiscounts = cartDiscounts;
      return this;
    }
  }
}
