package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeDiscountCodeGroups {
  private List<String> groups;

  public ChangeDiscountCodeGroups() {
  }

  public ChangeDiscountCodeGroups(List<String> groups) {
    this.groups = groups;
  }

  public List<String> getGroups() {
    return groups;
  }

  public void setGroups(List<String> groups) {
    this.groups = groups;
  }

  @Override
  public String toString() {
    return "ChangeDiscountCodeGroups{groups='" + groups + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeDiscountCodeGroups that = (ChangeDiscountCodeGroups) o;
    return Objects.equals(groups, that.groups);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groups);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> groups;

    public ChangeDiscountCodeGroups build() {
      ChangeDiscountCodeGroups result = new ChangeDiscountCodeGroups();
      result.groups = this.groups;
      return result;
    }

    public Builder groups(List<String> groups) {
      this.groups = groups;
      return this;
    }
  }
}
