package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeExtensionTriggers {
  private List<TriggerInput> triggers;

  public ChangeExtensionTriggers() {
  }

  public ChangeExtensionTriggers(List<TriggerInput> triggers) {
    this.triggers = triggers;
  }

  public List<TriggerInput> getTriggers() {
    return triggers;
  }

  public void setTriggers(List<TriggerInput> triggers) {
    this.triggers = triggers;
  }

  @Override
  public String toString() {
    return "ChangeExtensionTriggers{triggers='" + triggers + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeExtensionTriggers that = (ChangeExtensionTriggers) o;
    return Objects.equals(triggers, that.triggers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(triggers);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<TriggerInput> triggers;

    public ChangeExtensionTriggers build() {
      ChangeExtensionTriggers result = new ChangeExtensionTriggers();
      result.triggers = this.triggers;
      return result;
    }

    public Builder triggers(List<TriggerInput> triggers) {
      this.triggers = triggers;
      return this;
    }
  }
}
