package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeMyBusinessUnitAddress {
  private String addressId;

  private String addressKey;

  private AddressInput address;

  public ChangeMyBusinessUnitAddress() {
  }

  public ChangeMyBusinessUnitAddress(String addressId, String addressKey, AddressInput address) {
    this.addressId = addressId;
    this.addressKey = addressKey;
    this.address = address;
  }

  public String getAddressId() {
    return addressId;
  }

  public void setAddressId(String addressId) {
    this.addressId = addressId;
  }

  public String getAddressKey() {
    return addressKey;
  }

  public void setAddressKey(String addressKey) {
    this.addressKey = addressKey;
  }

  public AddressInput getAddress() {
    return address;
  }

  public void setAddress(AddressInput address) {
    this.address = address;
  }

  @Override
  public String toString() {
    return "ChangeMyBusinessUnitAddress{addressId='" + addressId + "', addressKey='" + addressKey + "', address='" + address + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeMyBusinessUnitAddress that = (ChangeMyBusinessUnitAddress) o;
    return Objects.equals(addressId, that.addressId) &&
        Objects.equals(addressKey, that.addressKey) &&
        Objects.equals(address, that.address);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addressId, addressKey, address);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String addressId;

    private String addressKey;

    private AddressInput address;

    public ChangeMyBusinessUnitAddress build() {
      ChangeMyBusinessUnitAddress result = new ChangeMyBusinessUnitAddress();
      result.addressId = this.addressId;
      result.addressKey = this.addressKey;
      result.address = this.address;
      return result;
    }

    public Builder addressId(String addressId) {
      this.addressId = addressId;
      return this;
    }

    public Builder addressKey(String addressKey) {
      this.addressKey = addressKey;
      return this;
    }

    public Builder address(AddressInput address) {
      this.address = address;
      return this;
    }
  }
}
