package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeMyBusinessUnitAssociate {
  private AssociateDraft associate;

  public ChangeMyBusinessUnitAssociate() {
  }

  public ChangeMyBusinessUnitAssociate(AssociateDraft associate) {
    this.associate = associate;
  }

  public AssociateDraft getAssociate() {
    return associate;
  }

  public void setAssociate(AssociateDraft associate) {
    this.associate = associate;
  }

  @Override
  public String toString() {
    return "ChangeMyBusinessUnitAssociate{associate='" + associate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeMyBusinessUnitAssociate that = (ChangeMyBusinessUnitAssociate) o;
    return Objects.equals(associate, that.associate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AssociateDraft associate;

    public ChangeMyBusinessUnitAssociate build() {
      ChangeMyBusinessUnitAssociate result = new ChangeMyBusinessUnitAssociate();
      result.associate = this.associate;
      return result;
    }

    public Builder associate(AssociateDraft associate) {
      this.associate = associate;
      return this;
    }
  }
}
