package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeOrderShipmentState {
  private ShipmentState shipmentState;

  public ChangeOrderShipmentState() {
  }

  public ChangeOrderShipmentState(ShipmentState shipmentState) {
    this.shipmentState = shipmentState;
  }

  public ShipmentState getShipmentState() {
    return shipmentState;
  }

  public void setShipmentState(ShipmentState shipmentState) {
    this.shipmentState = shipmentState;
  }

  @Override
  public String toString() {
    return "ChangeOrderShipmentState{shipmentState='" + shipmentState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeOrderShipmentState that = (ChangeOrderShipmentState) o;
    return Objects.equals(shipmentState, that.shipmentState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shipmentState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ShipmentState shipmentState;

    public ChangeOrderShipmentState build() {
      ChangeOrderShipmentState result = new ChangeOrderShipmentState();
      result.shipmentState = this.shipmentState;
      return result;
    }

    public Builder shipmentState(ShipmentState shipmentState) {
      this.shipmentState = shipmentState;
      return this;
    }
  }
}
