package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeOrderState {
  private OrderState orderState;

  public ChangeOrderState() {
  }

  public ChangeOrderState(OrderState orderState) {
    this.orderState = orderState;
  }

  public OrderState getOrderState() {
    return orderState;
  }

  public void setOrderState(OrderState orderState) {
    this.orderState = orderState;
  }

  @Override
  public String toString() {
    return "ChangeOrderState{orderState='" + orderState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeOrderState that = (ChangeOrderState) o;
    return Objects.equals(orderState, that.orderState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orderState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OrderState orderState;

    public ChangeOrderState build() {
      ChangeOrderState result = new ChangeOrderState();
      result.orderState = this.orderState;
      return result;
    }

    public Builder orderState(OrderState orderState) {
      this.orderState = orderState;
      return this;
    }
  }
}
