package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangePaymentTransactionState {
  private String transactionId;

  private TransactionState state;

  public ChangePaymentTransactionState() {
  }

  public ChangePaymentTransactionState(String transactionId, TransactionState state) {
    this.transactionId = transactionId;
    this.state = state;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public TransactionState getState() {
    return state;
  }

  public void setState(TransactionState state) {
    this.state = state;
  }

  @Override
  public String toString() {
    return "ChangePaymentTransactionState{transactionId='" + transactionId + "', state='" + state + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangePaymentTransactionState that = (ChangePaymentTransactionState) o;
    return Objects.equals(transactionId, that.transactionId) &&
        Objects.equals(state, that.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transactionId, state);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String transactionId;

    private TransactionState state;

    public ChangePaymentTransactionState build() {
      ChangePaymentTransactionState result = new ChangePaymentTransactionState();
      result.transactionId = this.transactionId;
      result.state = this.state;
      return result;
    }

    public Builder transactionId(String transactionId) {
      this.transactionId = transactionId;
      return this;
    }

    public Builder state(TransactionState state) {
      this.state = state;
      return this;
    }
  }
}
