package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class ChangePaymentTransactionTimestamp {
  private String transactionId;

  private OffsetDateTime timestamp;

  public ChangePaymentTransactionTimestamp() {
  }

  public ChangePaymentTransactionTimestamp(String transactionId, OffsetDateTime timestamp) {
    this.transactionId = transactionId;
    this.timestamp = timestamp;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public OffsetDateTime getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
  }

  @Override
  public String toString() {
    return "ChangePaymentTransactionTimestamp{transactionId='" + transactionId + "', timestamp='" + timestamp + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangePaymentTransactionTimestamp that = (ChangePaymentTransactionTimestamp) o;
    return Objects.equals(transactionId, that.transactionId) &&
        Objects.equals(timestamp, that.timestamp);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transactionId, timestamp);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String transactionId;

    private OffsetDateTime timestamp;

    public ChangePaymentTransactionTimestamp build() {
      ChangePaymentTransactionTimestamp result = new ChangePaymentTransactionTimestamp();
      result.transactionId = this.transactionId;
      result.timestamp = this.timestamp;
      return result;
    }

    public Builder transactionId(String transactionId) {
      this.transactionId = transactionId;
      return this;
    }

    public Builder timestamp(OffsetDateTime timestamp) {
      this.timestamp = timestamp;
      return this;
    }
  }
}
